/***
 * 
 * @author zhoujunhui
 */
package net.wicp.tams.common.spring.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.codahale.metrics.Counter;

import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.spring.SpringAssit;
import net.wicp.tams.common.spring.annotation.connector.CacheConnector;
import net.wicp.tams.common.spring.annotation.metrics.CounterTams;
import net.wicp.tams.common.spring.annotation.metrics.GaugeTams;
import net.wicp.tams.common.spring.annotation.metrics.HistogramTams;
import net.wicp.tams.common.spring.annotation.metrics.MeterTams;
import net.wicp.tams.common.spring.annotation.metrics.TimerTams;


public class AnnotationBean implements BeanFactoryPostProcessor, BeanPostProcessor, ApplicationContextAware {

	private String annotationPackage;

	private ApplicationContext applicationContext;

	public String getAnnotationPackage() {
		return annotationPackage;
	}

	public void setAnnotationPackage(String annotationPackage) {
		this.annotationPackage = annotationPackage;
	}

	public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory)
			throws BeansException {
		if (annotationPackage == null || annotationPackage.length() == 0) {
			return;
		}

		if (configurableListableBeanFactory instanceof BeanDefinitionRegistry) {
			try {
				// init scanner
				Class<?> scannerClass = ReflectAssist
						.forName("org.springframework.context.annotation.ClassPathBeanDefinitionScanner");
				Object scanner = scannerClass
						.getConstructor(new Class<?>[] { BeanDefinitionRegistry.class, boolean.class })
						.newInstance(new Object[] { (BeanDefinitionRegistry) configurableListableBeanFactory, true });
				// add filter
				Class<?> filterClass = ReflectAssist
						.forName("org.springframework.core.type.filter.AnnotationTypeFilter");
				Object filter = filterClass
						.getConstructor(Class.class, Class.class, Class.class, Class.class, Class.class).newInstance(
								Counter.class, GaugeTams.class, HistogramTams.class, MeterTams.class, TimerTams.class);
				Method addIncludeFilter = scannerClass.getMethod("addIncludeFilter",
						ReflectAssist.forName("org.springframework.core.type.filter.TypeFilter"));
				addIncludeFilter.invoke(scanner, filter);
				// scan packages
				String[] packages = StrPattern.split_pattern.compile().split(annotationPackage);
				Method scan = scannerClass.getMethod("scan", new Class<?>[] { String[].class });
				scan.invoke(scanner, new Object[] { packages });
			} catch (Throwable e) {

			}
		}

	}

	@Override
	public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
		return o;
	}

	// public Map<String, Counter> countermap=new HashMap<>();
	@Override
	public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
		/*
		 * if( o.getClass().getName().contains("TestController")) {
		 * if(AnnotationUtils.findAnnotation(o.getClass(), Controller.class) != null) {
		 * System.out.println(4); } System.out.println(3); List<Field> selectFields =
		 * selectFields(o.getClass()); System.out.println("selectFields="+selectFields);
		 * }
		 */
		
		CacheConnector cacheConnector = o.getClass().getDeclaredAnnotation(CacheConnector.class);
		if (cacheConnector != null) {
			CommonService commonService = this.applicationContext.getBean(CommonService.class);
			String[] beanNamesForType = this.applicationContext.getBeanNamesForType(o.getClass());
			for (String beanName : beanNamesForType) {
				commonService.needCacheMap.put(beanName,cacheConnector.expire());
			}			
		}

		doWithFields(o, s, CounterTams.class);
		doWithFields(o, s, HistogramTams.class);
		doWithFields(o, s, TimerTams.class);
		doWithFields(o, s, GaugeTams.class);
		doWithFields(o, s, MeterTams.class);
		return o;
	}

	private void doWithFields(Object o, String s, Class<? extends Annotation> classA) {
		List<Field> findFields = SpringAssit.selectFields(o.getClass(), classA);
		if (CollectionUtils.isNotEmpty(findFields)) {// 含有Conter
			for (Field field : findFields) {
				Annotation declaredAnnotation = field.getDeclaredAnnotation(classA);
				MetricsBean<Object> serviceBean = new MetricsBean<Object>(declaredAnnotation, field);
				serviceBean.setApplicationContext(applicationContext);
				serviceBean.setRef(o);
				try {
					serviceBean.afterPropertiesSet();
				} catch (Exception e) {
					throw new ProjectExceptionRuntime(ExceptAll.Project_default, "设置属性【" + s + "】失败");
				}
			}
		}
	}

	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}
}
