/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring;

import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.spring.SpringAssit;
import net.wicp.tams.common.spring.connector.ConnectorServlet;
import net.wicp.tams.common.spring.connector.SpringBusiManager;
import net.wicp.tams.common.spring.quartz.IScheduleJobStore;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Order(value=-2147483648)
public class ConfigInit {
    private static final Logger log = LoggerFactory.getLogger(ConfigInit.class);
    public static ApplicationContext context;
    @Autowired
    private SpringAssit springBootAssit;

    @PostConstruct
    private void init() {
        String[] addSingleAry;
        Properties inputpamas = new Properties();
        Properties tpProps = Conf.copyProperties();
        for (String needAddConf : addSingleAry = StringUtil.isNull((Object)Conf.get((String)"common.spring.conf.addSingle")) ? new String[]{} : Conf.get((String)"common.spring.conf.addSingle").split(",")) {
            if (tpProps.containsKey(needAddConf)) continue;
            tpProps.put(needAddConf, "null");
        }
        Map<String, String> allMap = this.springBootAssit.findAllProps();
        String[] addPreAry = StringUtil.isNull((Object)Conf.get((String)"common.spring.conf.addPre")) ? new String[]{} : Conf.get((String)"common.spring.conf.addPre").split(",");
        for (String keystr : allMap.keySet()) {
            boolean needAdd = tpProps.containsKey(keystr);
            if (!needAdd) {
                for (String addPreEle : addPreAry) {
                    if (!StringUtil.isNotNull((Object)addPreEle) || !keystr.startsWith(addPreEle)) continue;
                    needAdd = true;
                    break;
                }
            }
            if (!needAdd) continue;
            inputpamas.put(keystr, allMap.get(keystr));
        }
        log.info("input parmas:{}", (Object)inputpamas.toString());
        Conf.overProp((Properties)inputpamas);
    }

    @Bean
    @ConditionalOnBean(value={IScheduleJobStore.class})
    public SchedulerFactoryBean quartzJob() {
        return new SchedulerFactoryBean();
    }

    @Configuration
    @ConditionalOnClass(name={"net.wicp.tams.common.jdbc.DruidAssit", "org.mybatis.spring.SqlSessionFactoryBean"})
    public class MybatisConfig {
        @Bean(name={"primarySqlSessionFactory"})
        @Primary
        @ConditionalOnBean(name={"primaryDatasource"})
        public SqlSessionFactory rdsSqlSessionFactory(@Qualifier(value="primaryDatasource") DataSource primaryDataSource) throws Exception {
            SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
            sessionFactory.setDataSource(primaryDataSource);
            if (StringUtil.isNotNull((Object)Conf.get((String)"common.spring.mybatis.mapperLocations"))) {
                sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(Conf.get((String)"common.spring.mybatis.mapperLocations")));
            }
            if (StringUtil.isNotNull((Object)Conf.get((String)"common.spring.mybatis.configLocation"))) {
                sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver().getResource(Conf.get((String)"common.spring.mybatis.configLocation")));
            }
            return sessionFactory.getObject();
        }

        @Bean(name={"primarySqlSessionTemplate"})
        @Primary
        @ConditionalOnBean(name={"primarySqlSessionFactory"})
        public SqlSessionTemplate testSqlSessionTemplate(@Qualifier(value="primarySqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
            return new SqlSessionTemplate(sqlSessionFactory);
        }

        @Primary
        @Bean(name={"primaryJdbcTemplate"})
        @ConditionalOnBean(name={"primaryDatasource"})
        public JdbcTemplate primaryJdbcTemplate(@Qualifier(value="primaryDatasource") DataSource dataSource) {
            return new JdbcTemplate(dataSource);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"net.wicp.tams.common.jdbc.DruidAssit"})
    public class DruidDBConfig {
        @Bean(value={"primaryDatasource"})
        @Primary
        @ConditionalOnClass(name={"net.wicp.tams.common.jdbc.DruidAssit"})
        public DataSource dataSource() {
            DataSource datasource = DruidAssit.getInst().getDataSource();
            return datasource;
        }
    }

    @Configuration
    @ConditionalOnClass(value={CommonService.class})
    @Order(value=0x7FFFFFFF)
    public class ConnectionConfig {
        @Bean
        @ConditionalOnMissingBean
        protected IConfigManager createIConfigManager() {
            KeyConfigManager manage = new KeyConfigManager();
            return manage;
        }

        @Bean
        protected CommonService createExecutor(ApplicationContext context, IConfigManager configManager) {
            CommonService executor = new CommonService();
            SpringBusiManager busi = new SpringBusiManager(context);
            executor.setBusiManager((IBusiManager)busi);
            executor.setConfigManager(configManager);
            return executor;
        }

        @Bean
        public ConnectorServlet servlet() {
            return new ConnectorServlet();
        }

        @Bean
        public ServletRegistrationBean confServlet(ConnectorServlet servlet) {
            ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, true, new String[]{"/connector"});
            return registration;
        }
    }

    @Configuration
    @Order(value=-2147483648)
    protected class InitContext
    implements ApplicationContextAware {
        protected InitContext() {
        }

        public void setApplicationContext(ApplicationContext arg0) throws BeansException {
            context = arg0;
        }
    }
}

