/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-spring-autoconfig
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.spring.autoconfig.schema;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.util.MultiValueMap;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.spring.autoconfig.beans.AnnotationBean;

public class AnnotationRegistrar implements ImportBeanDefinitionRegistrar {

	@Override
	public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
		MultiValueMap<String, Object> allAnnotationAttributes = importingClassMetadata
				.getAllAnnotationAttributes("net.wicp.tams.common.spring.autoconfig.annotation.EnableTams");

		String springconfpres = String.valueOf(allAnnotationAttributes.getFirst("springconfpres"));
		if (StringUtil.isNotNull(springconfpres)) {
			Conf.overProp("common.spring.autoconfig.addPre", springconfpres);
		}

		String packages = String.valueOf(allAnnotationAttributes.getFirst("packages"));
		String mainpackage = ((StandardClassMetadata) importingClassMetadata).getIntrospectedClass().getPackage()
				.getName();
		if (StringUtil.isNull(packages)) {
			packages = mainpackage;
		} else if (!packages.contains(mainpackage)) {
			packages += "," + mainpackage;
		}
		RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
		rootBeanDefinition.setBeanClass(AnnotationBean.class);
		rootBeanDefinition.setLazyInit(false);
		rootBeanDefinition.getPropertyValues().addPropertyValue("annotationPackage", packages);
		rootBeanDefinition.getPropertyValues().addPropertyValue("mainPackage", mainpackage);
		String generatedBeanName = AnnotationBean.class.getName();
		registry.registerBeanDefinition(generatedBeanName, rootBeanDefinition);
	}

}
