/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.autoconfig.service.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.spring.autoconfig.beans.SocketParamBean;
import net.wicp.tams.common.spring.autoconfig.service.websocket.IWebSSHService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public abstract class WebServiceCommon<P extends SocketParamBean, C>
implements IWebSSHService {
    private static final Logger log = LoggerFactory.getLogger(WebServiceCommon.class);
    protected static Map<String, Object> sshMap = new ConcurrentHashMap<String, Object>();

    public Class<P> getPClass() {
        Class tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return tClass;
    }

    public Class<C> getCClass() {
        Class tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return tClass;
    }

    @Override
    public final void initConnection(WebSocketSession session) {
        String uuid = String.valueOf(session.getAttributes().get("user_uuid"));
        sshMap.put(uuid, this.initConnectionSub(session));
    }

    @Override
    public final void recvHandle(String buffer, WebSocketSession session) {
        P msgInfo = this.packMsgInfo(buffer, session);
        C connectInfo = this.packConnectInfo(session);
        if (msgInfo == null || ((SocketParamBean)msgInfo).getOperate() == null) {
            this.close(session);
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "Operate\u9700\u8981\u4f20\u503c");
        }
        switch (((SocketParamBean)msgInfo).getOperate()) {
            case connect: {
                this.doConnect(msgInfo, connectInfo, session);
                break;
            }
            case command: {
                this.doCommand(msgInfo, connectInfo, session);
                break;
            }
            default: {
                log.error("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
                this.close(session);
            }
        }
    }

    protected abstract void doConnect(P var1, C var2, WebSocketSession var3);

    protected abstract void doCommand(P var1, C var2, WebSocketSession var3);

    @Override
    public void sendMessage(WebSocketSession session, byte[] buffer) throws IOException {
        session.sendMessage((WebSocketMessage)new TextMessage(buffer));
    }

    @Override
    public final void close(WebSocketSession session) {
        String userId = String.valueOf(session.getAttributes().get("user_uuid"));
        C connectInfo = this.packConnectInfo(session);
        if (connectInfo != null) {
            this.closeSub(connectInfo);
            sshMap.remove(userId);
        }
    }

    protected P packMsgInfo(String buffer, WebSocketSession session) {
        ObjectMapper objectMapper = new ObjectMapper();
        SocketParamBean params = null;
        try {
            params = (SocketParamBean)objectMapper.readValue(buffer, this.getPClass());
        }
        catch (IOException e) {
            String msg = String.format("\u8f6c\u6362\u53c2\u6570\uff0c\u4f20\u8fc7\u6765\u7684\u53c2\u6570\uff1a%s ,\u53c2\u6570\u7c7b\u578b\uff1a%s ,\u5f02\u5e38\u4fe1\u606f:%s", buffer, this.getPClass().getName(), e.getMessage());
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, msg, (Throwable)e);
        }
        return (P)params;
    }

    protected C packConnectInfo(WebSocketSession session) {
        String userId = String.valueOf(session.getAttributes().get("user_uuid"));
        Object connectInfo = sshMap.get(userId);
        return (C)connectInfo;
    }

    protected void transCmd(OutputStream outputStream, String command) {
        if (outputStream != null) {
            try {
                outputStream.write(command.getBytes());
                outputStream.flush();
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u547d\u4ee4\u5931\u8d25:" + command, (Throwable)e);
            }
        }
    }

    public abstract C initConnectionSub(WebSocketSession var1);

    public abstract void closeSub(C var1);
}

