/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-spring-autoconfig
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.spring.autoconfig.service;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

/***
 * springBean的回调接口
 * 
 * @author Andy
 *
 */
public interface IAnnotationBean {
	/***
	 * factory执行成功后回调
	 * 
	 * @param mainPackage spring的主类所在的包，有EnableTams注解的包。
	 * @param registry
	 * @throws BeansException
	 */
	public void postProcessBeanFactory(String mainPackage, BeanDefinitionRegistry registry) throws BeansException;
}
