/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-spring-autoconfig
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.spring.autoconfig.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;

import net.wicp.tams.common.spring.autoconfig.schema.AnnotationImportSeletor;
import net.wicp.tams.common.spring.autoconfig.schema.AnnotationRegistrar;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
@Import({ AnnotationRegistrar.class, AnnotationImportSeletor.class })
public @interface EnableTams {
	/***
	 * 逗号分隔,需要扫描的包
	 * 
	 * @return
	 */
	String packages() default "";

	/**
	 * spring配置的前缀，逗号分隔,它会加到内存配置中心
	 * 
	 * @return
	 */
	String springconfpres() default "";
}
