/*
 * Copyright (C) 2018 Xplat, Inc. All Rights Reserved.
 */
package net.wicp.tams.common.spring.autoconfig.schema;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/***
 * 
* @author zhoujunhui
 */
public class TamsBeanDefinitionParser implements BeanDefinitionParser {

	private final Class<?> beanClass;

	public TamsBeanDefinitionParser(Class<?> beanClass) {
		this.beanClass = beanClass;
	}

	public BeanDefinition parse(Element element, ParserContext parserContext) {
		return parse(element, parserContext, beanClass);
	}

	private BeanDefinition parse(Element element, ParserContext parserContext, Class<?> beanClass) {
		RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
		rootBeanDefinition.setBeanClass(beanClass);
		rootBeanDefinition.setLazyInit(false);
		String annotationPackage = element.getAttribute("package");
		rootBeanDefinition.getPropertyValues().addPropertyValue("annotationPackage", annotationPackage);
		String generatedBeanName = beanClass.getName();
		parserContext.getRegistry().registerBeanDefinition(generatedBeanName, rootBeanDefinition);
		return rootBeanDefinition;
	}

}
