/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.autoconfig.constant;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.spring.autoconfig.constant.IConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpringConf
extends Enum<SpringConf> {
    public static final /* enum */ SpringConf consul;
    public static final /* enum */ SpringConf apollo;
    public static final /* enum */ SpringConf configserver;
    public static final /* enum */ SpringConf bootstrap;
    public static final /* enum */ SpringConf application;
    private static final Logger log;
    private final String keyPre;
    private int order;
    private IConvert convert;
    private final Map<String, LinkedHashMap<String, String>> props = new HashMap<String, LinkedHashMap<String, String>>();
    private static final /* synthetic */ SpringConf[] $VALUES;

    public static SpringConf[] values() {
        return (SpringConf[])$VALUES.clone();
    }

    public static SpringConf valueOf(String name) {
        return Enum.valueOf(SpringConf.class, name);
    }

    private SpringConf(String keyPre, int order) {
        this.keyPre = keyPre;
        this.order = order;
    }

    public void setConvert(IConvert convert) {
        this.convert = convert;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getKeyPre() {
        return this.keyPre;
    }

    public Map<String, LinkedHashMap<String, String>> getProps() {
        return this.props;
    }

    public Map<String, String> getPropsConvert(String filekey, Map<String, String> allMap) {
        return this.convert == null ? (Map<String, String>)this.props.get(filekey) : this.convert.convertMap(filekey, (Map<String, String>)this.props.get(filekey), allMap);
    }

    public static SpringConf[] sortDesc() {
        SpringConf[] values = SpringConf.values();
        Arrays.sort(values, new Comparator<SpringConf>(){

            @Override
            public int compare(SpringConf o1, SpringConf o2) {
                return o2.getOrder() - o1.getOrder();
            }
        });
        return values;
    }

    static {
        SpringConf[] values;
        consul = new SpringConf("consul:", 1);
        apollo = new SpringConf("ApolloBootstrapPropertySources:", 2);
        configserver = new SpringConf("configService:", 3);
        bootstrap = new SpringConf("applicationConfig: [classpath:/bootstrap-", 4);
        application = new SpringConf("applicationConfig: [classpath:/application-", 5);
        $VALUES = new SpringConf[]{consul, apollo, configserver, bootstrap, application};
        log = LoggerFactory.getLogger(SpringConf.class);
        for (SpringConf value : values = SpringConf.values()) {
            String convertClass = Conf.get((String)("common.spring.autoconfig.convert." + value.name()));
            if (!StringUtil.isNotNull((Object)convertClass)) continue;
            try {
                IConvert convert = (IConvert)Class.forName(convertClass).newInstance();
                value.setConvert(convert);
            }
            catch (Exception e) {
                log.error(convertClass + "\u8f6c\u6362\u5668\u521b\u5efa\u9519\u8bef", (Throwable)e);
            }
        }
    }
}

