/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-spring-autoconfig
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.spring.autoconfig.property;

import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.spring.autoconfig.constant.ConstantGloble;

@Order(0)
public class TamsPropertySource implements PropertySourceLocator {
	@Override
	public PropertySource<?> locate(Environment environment) {
		CompositePropertySource composite = new CompositePropertySource("tams");
		PropertiesPropertySource mapPropertySource = new PropertiesPropertySource(ConstantGloble.ConfiNameForTams, Conf.copyProperties());
		composite.addPropertySource(mapPropertySource);
		return composite;
	}
}
