package net.wicp.tams.common.spring.autoconfig.beans;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.stereotype.Service;

import net.wicp.tams.common.apiext.StringUtil;

public class UniqueNameGenerator extends AnnotationBeanNameGenerator {
	@Override
	public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
//		if(definition.getBeanClassName().equalsIgnoreCase("net.wicp.tams.moudle.tams.moudle.cas.service.impl.MenuService")) {
//		}		
		if (definition instanceof ScannedGenericBeanDefinition) {
			ScannedGenericBeanDefinition scannedGenericBeanDefinition = (ScannedGenericBeanDefinition) definition;
			MergedAnnotations mergedAnnotations = scannedGenericBeanDefinition.getMetadata().getAnnotations();
			if (mergedAnnotations != null) {
				MergedAnnotation<Service> annotation = mergedAnnotations.get(Service.class);
				if (annotation.isPresent()) {//需要支持@Service("abc")这种情况
					String value = annotation.getRoot().getString("value");
					if (StringUtil.isNotNull(value)) {
						return value;
					}
				}
			}
		}
		// 全限定类名
		String beanName = definition.getBeanClassName();
		return beanName;
	}
}
