/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-spring-autoconfig
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
/***
 * 
 * @author zhoujunhui
 */
package net.wicp.tams.common.spring.autoconfig.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public abstract class FieldBean<T> implements InitializingBean, ApplicationContextAware {

	protected ApplicationContext applicationContext;

	protected final Annotation annotationInst;
	protected final Field field;

	public FieldBean(Annotation annotationInst, Field field) {
		this.annotationInst = annotationInst;
		this.field = field;
	}

	private T ref;

	public T getRef() {
		return ref;
	}

	public void setRef(T ref) {
		this.ref = ref;
	}

	@Override
	public final void afterPropertiesSet() throws Exception {
		Object doWithAnnotation = doWithAnnotation();
		if (!field.isAccessible()) {
			field.setAccessible(true);
		}
		field.set(ref, doWithAnnotation);
		log.info("the field:{} has inited", field.getName());
	}

	public abstract Object doWithAnnotation();

	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}
}
