/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.autoconfig.beans;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.FreemarkUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.spring.autoconfig.IContextInit;
import net.wicp.tams.common.spring.autoconfig.SpringAssit;
import net.wicp.tams.common.spring.autoconfig.beans.FieldBean;
import net.wicp.tams.common.spring.autoconfig.beans.TypeBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class AnnotationBean
implements BeanFactoryPostProcessor,
BeanPostProcessor,
ApplicationContextAware,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBean.class);
    private String annotationPackage;
    private SpringAssit springAssit;
    private Map<Class<? extends Annotation>, String> cusFieldMap = new HashMap<Class<? extends Annotation>, String>();
    private Map<Class<? extends Annotation>, String> cusTypeMap = new HashMap<Class<? extends Annotation>, String>();

    public String getAnnotationPackage() {
        return this.annotationPackage;
    }

    public void setAnnotationPackage(String annotationPackage) {
        this.annotationPackage = annotationPackage;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        if (StringUtil.isNull((Object)this.annotationPackage)) {
            return;
        }
        this.annotationPackage = FreemarkUtil.getInst().doProcessByTemp(this.annotationPackage, this.springAssit.findAllProps());
        if (StringUtil.isNull((Object)this.annotationPackage)) {
            return;
        }
        if (configurableListableBeanFactory instanceof BeanDefinitionRegistry) {
            try {
                Class scannerClass = ReflectAssist.forName((String)"org.springframework.context.annotation.ClassPathBeanDefinitionScanner");
                Object scanner = scannerClass.getConstructor(BeanDefinitionRegistry.class, Boolean.TYPE).newInstance((BeanDefinitionRegistry)configurableListableBeanFactory, true);
                Class filterClass = ReflectAssist.forName((String)"org.springframework.core.type.filter.AnnotationTypeFilter");
                Method addIncludeFilter = scannerClass.getMethod("addIncludeFilter", ReflectAssist.forName((String)"org.springframework.core.type.filter.TypeFilter"));
                for (Class<? extends Annotation> annotation : this.cusTypeMap.keySet()) {
                    Object tempAnnotion = filterClass.getConstructor(Class.class).newInstance(annotation);
                    addIncludeFilter.invoke(scanner, tempAnnotion);
                }
                String[] packages = StrPattern.split_pattern.compile().split(this.annotationPackage);
                Method scan = scannerClass.getMethod("scan", String[].class);
                scan.invoke(scanner, new Object[]{packages});
            }
            catch (Throwable e) {
                log.error("\u6dfb\u52a0\u626b\u63cf\u6ce8\u89e3\u5931\u8d25", e);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        String cusFieldStr;
        boolean isType = false;
        for (Class<? extends Annotation> key : this.cusTypeMap.keySet()) {
            cusFieldStr = this.cusTypeMap.get(key);
            Annotation declaredAnnotation = o.getClass().getDeclaredAnnotation(key);
            if (declaredAnnotation == null) continue;
            try {
                TypeBean serviceBean = (TypeBean)ReflectAssist.forName((String)cusFieldStr).getConstructor(Annotation.class).newInstance(declaredAnnotation);
                serviceBean.setApplicationContext(SpringAssit.context);
                serviceBean.setRef(o);
                serviceBean.afterPropertiesSet();
            }
            catch (Exception e) {
                log.error("\u5904\u7406type\u7c7b\u578b\u7684Annotation\u5931\u8d25", (Throwable)e);
            }
            finally {
                isType = true;
            }
        }
        if (!isType) {
            for (Class<? extends Annotation> key : this.cusFieldMap.keySet()) {
                cusFieldStr = this.cusFieldMap.get(key);
                this.doWithFields(o, s, key, cusFieldStr);
            }
        }
        return o;
    }

    private void doWithFields(Object o, String s, Class<? extends Annotation> classA, String cusDoWith) {
        List<Field> findFields = SpringAssit.selectFields(o.getClass(), classA);
        if (CollectionUtils.isNotEmpty(findFields)) {
            for (Field field : findFields) {
                try {
                    Annotation declaredAnnotation = field.getDeclaredAnnotation(classA);
                    FieldBean serviceBean = (FieldBean)ReflectAssist.forName((String)cusDoWith).getConstructor(Annotation.class, Field.class).newInstance(declaredAnnotation, field);
                    serviceBean.setApplicationContext(SpringAssit.context);
                    serviceBean.setRef(o);
                    serviceBean.afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u8bbe\u7f6e\u5c5e\u6027\u3010" + s + "\u3011\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringAssit.context = applicationContext;
        Map contextInitMap = Conf.getPre((String)"common.spring.autoconfig.contextInit", (boolean)true);
        for (String key : contextInitMap.keySet()) {
            try {
                IContextInit tempInit = (IContextInit)Class.forName((String)contextInitMap.get(key)).getConstructor(new Class[0]).newInstance(new Object[0]);
                tempInit.init(applicationContext);
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void setEnvironment(Environment environment) {
        String[] addSingleAry;
        this.springAssit = new SpringAssit(environment);
        Properties inputpamas = new Properties();
        Properties tpProps = Conf.copyProperties();
        for (String needAddConf : addSingleAry = StringUtil.isNull((Object)Conf.get((String)"common.spring.autoconfig.addSingle")) ? new String[]{} : Conf.get((String)"common.spring.autoconfig.addSingle").split(",")) {
            if (tpProps.containsKey(needAddConf)) continue;
            tpProps.put(needAddConf, "null");
        }
        Map<String, String> allMap = this.springAssit.findAllProps();
        String[] addPreArytemp = StringUtil.isNull((Object)Conf.get((String)"common.spring.autoconfig.addPre")) ? new String[]{} : Conf.get((String)"common.spring.autoconfig.addPre").split(",");
        String[][] addPreAryTrue = new String[addPreArytemp.length][2];
        for (int i = 0; i < addPreArytemp.length; ++i) {
            addPreAryTrue[i] = addPreArytemp[i].split(":");
        }
        for (String keystr : allMap.keySet()) {
            boolean needAdd = tpProps.containsKey(keystr);
            Object[] selPre = null;
            if (!needAdd) {
                for (Object[] objectArray : addPreAryTrue) {
                    if (!ArrayUtils.isNotEmpty((Object[])objectArray) || !keystr.startsWith((String)objectArray[0])) continue;
                    needAdd = true;
                    selPre = objectArray;
                    break;
                }
            }
            if (!needAdd) continue;
            String keytrue = ArrayUtils.isEmpty(selPre) ? keystr : (selPre.length > 1 ? keystr.replace((CharSequence)selPre[0], (CharSequence)selPre[1]) : keystr);
            inputpamas.put(keytrue, allMap.get(keystr));
        }
        log.info("input parmas:{}", (Object)inputpamas.toString());
        Conf.overProp((Properties)inputpamas);
        Map pre = Conf.getPre((String)"common.spring.autoconfig.annotation", (boolean)true);
        for (String key : pre.keySet()) {
            try {
                int indexOf = key.indexOf(".");
                String elementtype = key.substring(0, indexOf);
                String className = key.substring(indexOf + 1);
                ElementType elementType = ElementType.valueOf(elementtype);
                Class<?> clazz = Class.forName(className);
                switch (elementType) {
                    case FIELD: {
                        this.cusFieldMap.put((Class<? extends Annotation>)clazz, (String)pre.get(key));
                        break;
                    }
                    case TYPE: {
                        this.cusTypeMap.put((Class<? extends Annotation>)clazz, (String)pre.get(key));
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
            }
        }
    }
}

