package net.wicp.tams.common.spring.autoconfig.property;

import java.io.File;
import java.util.Properties;

import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.PathType;

@Order(0)
public class PathPropertySource implements PropertySourceLocator {
	@Override
	public PropertySource<?> locate(Environment environment) {
		String propertypath = environment.getProperty("common.spring.autoconfig.property.path");// spring其它的优先配置文件：bootstrap.yml
																								// 等
		String monerypath = Conf.get("common.spring.autoconfig.property.path");// 内存配置中心
		Properties fileToProperties = null;
		if (StringUtil.isNotNull(propertypath)) {
			String propsPathTrue = PathType.getPath(propertypath, false);
			fileToProperties = IOUtil.fileToProperties(new File(propsPathTrue));
		}
		if (StringUtil.isNotNull(monerypath)) {
			String propsPathTrue = PathType.getPath(monerypath, false);
			Properties tempProps = IOUtil.fileToProperties(new File(propsPathTrue));
			if (fileToProperties == null) {
				fileToProperties = tempProps;
			} else {
				for (Object key : tempProps.keySet()) {
					fileToProperties.put(key, tempProps.get(key));
				}
			}
		}
		CompositePropertySource composite = new CompositePropertySource("PathProperty");
		PropertiesPropertySource mapPropertySource = new PropertiesPropertySource("pathConfig", fileToProperties);
		composite.addPropertySource(mapPropertySource);
		return composite;
	}
}
