package net.wicp.tams.common.paimon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Triple;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.RowKind;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.FieldFormart;

@Slf4j
public abstract class PaimonAssit {
	private PaimonAssit() {
		
	}

	// 创建paimon的表
	public static Result createTable(Catalog catalog, MySqlTbBean catalogTbInfo, List<MySqlColBean> mysqlColList,
			FieldFormart fieldFormart) {
		List<String> keyCols = new ArrayList<>();
		Schema.Builder schemaBuilder = Schema.newBuilder();
		if (StringUtil.isNotNull(catalogTbInfo.getWithOptions())) {
			try {
				ObjectNode optionJson =  JSONUtil.parserStr(new ObjectMapper(), catalogTbInfo.getWithOptions());
				for (Iterator<String> iterator = optionJson.fieldNames(); iterator.hasNext();) {
					String key = iterator.next();
					schemaBuilder.option(key, optionJson.get(key).asText());
				}
			} catch (Exception e) {
				log.error("解析option时失败:" + catalogTbInfo.getDb() + "." + catalogTbInfo.getTb(), e);
			}
		}
		schemaBuilder.option("write-mode", "auto");// 默认为auto,有主键就是change-log，没有主键就是append-only
		for (MySqlColBean mySqlColBean : mysqlColList) {
			if (mySqlColBean.isPri()) {
				keyCols.add(mySqlColBean.getColumnNameStandard(fieldFormart));
			}
			FlinkTypeEnum flinkTypeEnum = StringUtil.isNull(mySqlColBean.getFlinkTypeEnum())
					? FlinkTypeEnum.getByDataType(mySqlColBean.getDataType())
					: FlinkTypeEnum.valueOf(mySqlColBean.getFlinkTypeEnum());
			schemaBuilder.column(mySqlColBean.getColumnNameStandard(fieldFormart), flinkTypeEnum.getConvert().getObj());
		}
		schemaBuilder.primaryKey(keyCols);
		Schema schema = schemaBuilder.build();
		Identifier identifier = Identifier.create(catalogTbInfo.getDb(), catalogTbInfo.getTb());
		try {
			catalog.createTable(identifier, schema, false);
			return Result.getSuc();
		} catch (Catalog.TableAlreadyExistException e) {
			return Result.getError("表已存");
		} catch (Catalog.DatabaseNotExistException e) {
			return Result.getError("库不存丰");
		}
	}

	// 如何拿到列的信息，字段类型与字段信息
	public static GenericRow convertFromMap(List<Triple<String, FlinkTypeEnum, LogicalType>> colList,
			Map<String, String> data, boolean isAfter) {
		Object[] values = new Object[colList.size()];
		for (int i = 0; i < values.length; i++) {
			values[i] = FlinkTypeEnum.getValue(colList.get(i).getMiddle(), data.get(colList.get(i).getLeft()),
					colList.get(i).getRight());
		}
		GenericRow returnObj = GenericRow.ofKind(isAfter ? RowKind.INSERT : RowKind.DELETE, values);
		return returnObj;
	}
}
