/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.paimon;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.paimon.FlinkTypeEnum;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaimonAssit {
    private static final Logger log = LoggerFactory.getLogger(PaimonAssit.class);

    public static Result createTable(Catalog catalog, MySqlTbBean catalogTbInfo, List<MySqlColBean> mysqlColList, FieldFormart fieldFormart) {
        ArrayList<String> keyCols = new ArrayList<String>();
        Schema.Builder schemaBuilder = Schema.newBuilder();
        if (StringUtil.isNotNull((Object)catalogTbInfo.getWithOptions())) {
            try {
                JSONObject optionJson = JSONObject.parseObject((String)catalogTbInfo.getWithOptions());
                for (String key : optionJson.keySet()) {
                    schemaBuilder.option(key, optionJson.getString(key));
                }
            }
            catch (Exception e) {
                log.error("\u89e3\u6790option\u65f6\u5931\u8d25:" + catalogTbInfo.getDb() + "." + catalogTbInfo.getTb(), (Throwable)e);
            }
        }
        schemaBuilder.option("write-mode", "auto");
        for (MySqlColBean mySqlColBean : mysqlColList) {
            if (mySqlColBean.isPri()) {
                keyCols.add(mySqlColBean.getColumnNameStandard(fieldFormart));
            }
            FlinkTypeEnum flinkTypeEnum = StringUtil.isNull((Object)mySqlColBean.getFlinkTypeEnum()) ? FlinkTypeEnum.getByDataType(mySqlColBean.getDataType()) : FlinkTypeEnum.valueOf(mySqlColBean.getFlinkTypeEnum());
            schemaBuilder.column(mySqlColBean.getColumnNameStandard(fieldFormart), (DataType)flinkTypeEnum.getConvert().getObj());
        }
        schemaBuilder.primaryKey(keyCols);
        Schema schema = schemaBuilder.build();
        Identifier identifier = Identifier.create((String)catalogTbInfo.getDb(), (String)catalogTbInfo.getTb());
        try {
            catalog.createTable(identifier, schema, false);
            return Result.getSuc();
        }
        catch (Catalog.TableAlreadyExistException e) {
            return Result.getError((String)"\u8868\u5df2\u5b58");
        }
        catch (Catalog.DatabaseNotExistException e) {
            return Result.getError((String)"\u5e93\u4e0d\u5b58\u4e30");
        }
    }

    public static GenericRow convertFromMap(List<Triple<String, FlinkTypeEnum, LogicalType>> colList, Map<String, String> data, boolean isAfter) {
        Object[] values = new Object[colList.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = FlinkTypeEnum.getValue((FlinkTypeEnum)((Object)colList.get(i).getMiddle()), data.get(colList.get(i).getLeft()), (LogicalType)colList.get(i).getRight());
        }
        GenericRow returnObj = GenericRow.ofKind((RowKind)(isAfter ? RowKind.INSERT : RowKind.DELETE), (Object[])values);
        return returnObj;
    }
}

