/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.paimon;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.paimon.IFlinkTypeCallback;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;

public enum FlinkTypeEnum implements IEnumCombobox
{
    BOOLEAN("boolean\u578b", ListenerConf.ColumnType.BIT, new String[0], new String[]{"bit"}, (Type)((Object)Boolean.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.BOOLEAN();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(BOOLEAN, "false", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "BOOLEAN";
        }
    }),
    CHAR("CHAR", ListenerConf.ColumnType.VARCHAR, new String[0], new String[]{"char"}, (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.STRING();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(CHAR, "N", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "STRING";
        }
    }),
    VARCHAR("VARCHAR", ListenerConf.ColumnType.VARCHAR, new String[]{"string"}, new String[]{"varchar", "json", "text", "tinytext", "longtext"}, (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.STRING();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(VARCHAR, "NA", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "STRING";
        }
    }),
    BINARY("BINARY", ListenerConf.ColumnType.DATETIME, new String[0], new String[]{"binary"}, (Type)((Object)byte[].class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.BYTES();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(BINARY, "NA", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "BYTES";
        }
    }),
    VARBINARY("VARBINARY", ListenerConf.ColumnType.DATETIME, new String[0], new String[]{"blob"}, (Type)((Object)byte[].class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.BYTES();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(VARBINARY, "NA", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "BYTES";
        }
    }),
    DECIMAL("DECIMAL", ListenerConf.ColumnType.DECIMAL, new String[0], new String[]{"decimal"}, (Type)((Object)BigDecimal.class), new IFlinkTypeCallback(){

        @Override
        public DataType getObj(int precision, int scale) {
            return DataTypes.DECIMAL((int)precision, (int)scale);
        }

        public DataType getObj() {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "decimal\u5fc5\u987b\u63d0\u4f9bprecision\u548cscale");
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(DECIMAL, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "DECIMAL";
        }
    }),
    TINYINT("\u77ed\u6574\u5f62\uff08<255\uff09", ListenerConf.ColumnType.TINY, new String[0], new String[0], (Type)((Object)Integer.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.TINYINT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(TINYINT, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "TINYINT";
        }
    }),
    SMALLINT("\u5c0f\u6574\u578b\uff08<65535\uff09", ListenerConf.ColumnType.SHORT, new String[0], new String[0], (Type)((Object)Integer.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.SMALLINT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(SMALLINT, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "SMALLINT";
        }
    }),
    INTEGER("\u6574\u578b", ListenerConf.ColumnType.INT24, new String[]{"int"}, new String[]{"integer", "int", "smallint", "tinyint"}, (Type)((Object)Integer.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.INT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(INTEGER, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "INT";
        }
    }),
    BIGINT("\u957f\u6574\u578b", ListenerConf.ColumnType.LONG, new String[0], new String[]{"bigint"}, (Type)((Object)Long.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.BIGINT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(BIGINT, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "BIGINT";
        }
    }),
    FLOAT("\u5355\u7cbe\u5ea6\u6d6e\u70b9\u578b", ListenerConf.ColumnType.FLOAT, new String[0], new String[]{"float"}, (Type)((Object)Float.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.FLOAT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(FLOAT, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "FLOAT";
        }
    }),
    DOUBLE("\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u578b", ListenerConf.ColumnType.DOUBLE, new String[0], new String[]{"double"}, (Type)((Object)Double.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.DOUBLE();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(DOUBLE, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "DOUBLE";
        }
    }),
    DATE("\u65e5\u671f", ListenerConf.ColumnType.DATE, new String[0], new String[0], (Type)((Object)Integer.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.DATE();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(DATE, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "DATE";
        }
    }),
    TIME_WITHOUT_TIME_ZONE("\u65f6\u95f4", ListenerConf.ColumnType.DATE, new String[0], new String[0], (Type)((Object)Integer.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.TIME();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(TIME_WITHOUT_TIME_ZONE, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "TIME";
        }
    }),
    TIMESTAMP_WITH_LOCAL_TIME_ZONE("TIMESTAMP_WITH_LOCAL_TIME_ZONE", ListenerConf.ColumnType.DATETIME, new String[0], new String[]{"date", "datetime", "timestamp"}, (Type)((Object)java.util.Date.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.TIMESTAMP((int)3);
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(TIMESTAMP_WITH_LOCAL_TIME_ZONE, "1970-01-01", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "TIMESTAMP_LTZ";
        }
    }),
    TIMESTAMP_WITH_TIME_ZONE("TIMESTAMP_WITH_TIME_ZONE", ListenerConf.ColumnType.DATETIME, new String[0], new String[0], (Type)((Object)java.util.Date.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.TIMESTAMP((int)3);
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(TIMESTAMP_WITH_TIME_ZONE, "1970-01-01", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "TIMESTAMP";
        }
    }),
    TIMESTAMP_WITHOUT_TIME_ZONE("TIMESTAMP_WITHOUT_TIME_ZONE", ListenerConf.ColumnType.DATETIME, new String[0], new String[0], (Type)((Object)java.util.Date.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.TIMESTAMP((int)3);
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(TIMESTAMP_WITHOUT_TIME_ZONE, "1970-01-01", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "TIMESTAMP";
        }
    }),
    INTERVAL_DAY_TIME("INTERVAL_DAY_TIME", ListenerConf.ColumnType.LONG, new String[0], new String[0], (Type)((Object)Long.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.BIGINT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(INTERVAL_DAY_TIME, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "BIGINT";
        }
    }),
    INTERVAL_YEAR_MONTH("INTERVAL_YEAR_MONTH", ListenerConf.ColumnType.SHORT, new String[0], new String[0], (Type)((Object)Integer.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return DataTypes.INT();
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(INTERVAL_YEAR_MONTH, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "INT";
        }
    }),
    ROW("ROW", ListenerConf.ColumnType.VARCHAR, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(ROW, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return "ROW";
        }
    }),
    ARRAY("ARRAY", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(ARRAY, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    MAP("MAP", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(MAP, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    MULTISET("MULTISET", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(MULTISET, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    RAW("RAW", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(RAW, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    STRUCTURED_TYPE("STRUCTURED_TYPE", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(STRUCTURED_TYPE, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    DISTINCT_TYPE("DISTINCT_TYPE", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(DISTINCT_TYPE, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    SYMBOL("SYMBOL", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(SYMBOL, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    }),
    UNRESOLVED("UNRESOLVED", null, new String[0], new String[0], (Type)((Object)String.class), new IFlinkTypeCallback(){

        public DataType getObj() {
            return null;
        }

        @Override
        public Object getDefaultValue(LogicalType logicalType) {
            return FlinkTypeEnum.getValue(UNRESOLVED, "0", logicalType);
        }

        @Override
        public String getDataTypeStr() {
            return null;
        }
    });

    private final String desc;
    private final String[] mysqlTypes;
    private final String[] logicType;
    private final ListenerConf.ColumnType columnType;
    private final int defaultPrecision = 38;
    private final int defaultScale = 4;
    private final Type javaType;
    private final IFlinkTypeCallback convert;

    public IFlinkTypeCallback getConvert() {
        return this.convert;
    }

    public String[] getMysqlTypes() {
        return this.mysqlTypes;
    }

    private FlinkTypeEnum(String desc, ListenerConf.ColumnType columnType, String[] logicType, String[] mysqlTypes, Type javaType, IFlinkTypeCallback convert) {
        this.desc = desc;
        this.mysqlTypes = mysqlTypes;
        this.javaType = javaType;
        this.convert = convert;
        this.logicType = logicType;
        this.columnType = columnType;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public String getStr(Object obj) {
        return String.valueOf(obj);
    }

    public static FlinkTypeEnum findByFlinkRowType(String flinkRowType) {
        if (StringUtils.isEmpty((CharSequence)flinkRowType)) {
            return null;
        }
        for (FlinkTypeEnum ele : FlinkTypeEnum.values()) {
            if (!StringUtil.blankToChart((String)flinkRowType, (String)"_", (boolean)true).equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return null;
    }

    public static FlinkTypeEnum findByMysqlType(String datatype, String columnType, Middleware middleware) {
        if (StringUtil.isNull((Object)datatype)) {
            return VARCHAR;
        }
        String mysqltypelower = datatype.toLowerCase();
        if (middleware == Middleware.mysql && "tinyint(1)".equalsIgnoreCase(columnType)) {
            return BOOLEAN;
        }
        for (FlinkTypeEnum ele : FlinkTypeEnum.values()) {
            if (!ArrayUtils.contains((Object[])ele.getMysqlTypes(), (Object)mysqltypelower)) continue;
            return ele;
        }
        return VARCHAR;
    }

    public static FlinkTypeEnum findByLogicType(String logicType) {
        if (StringUtil.isNull((Object)logicType)) {
            return null;
        }
        for (FlinkTypeEnum ele : FlinkTypeEnum.values()) {
            if (!ArrayUtils.contains((Object[])ele.getLogicType(), (Object)logicType.toLowerCase())) continue;
            return ele;
        }
        return null;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public static <T> T getValue(FlinkTypeEnum flinkTypeEnum, String value, LogicalType logicalType) {
        Object retobj = null;
        if (StringUtil.isNull((Object)value)) {
            return null;
        }
        if ("java.lang.String".equals(flinkTypeEnum.getJavaType().getTypeName())) {
            retobj = BinaryString.fromString((String)value);
            return (T)retobj;
        }
        switch (flinkTypeEnum) {
            case CHAR: 
            case VARCHAR: {
                retobj = value;
            }
            case BOOLEAN: {
                value = "1".equals(value) ? "true" : "false";
                retobj = Boolean.valueOf(value);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                retobj = value.getBytes();
                break;
            }
            case DECIMAL: {
                BigDecimal bd = new BigDecimal(value);
                DecimalType typeTrue = (DecimalType)logicalType;
                retobj = Decimal.fromBigDecimal((BigDecimal)bd, (int)typeTrue.getPrecision(), (int)typeTrue.getScale());
                break;
            }
            case TINYINT: {
                retobj = Byte.valueOf(value);
                break;
            }
            case SMALLINT: {
                retobj = Short.valueOf(value);
                break;
            }
            case INTEGER: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                retobj = Integer.valueOf(value);
                break;
            }
            case DATE: {
                retobj = DateUtil.objToDate((Object)value);
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                retobj = Long.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                Timestamp time = new Timestamp(DateUtil.objToDate((Object)value).getTime());
                retobj = org.apache.paimon.data.Timestamp.fromEpochMillis((long)time.getTime());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                java.util.Date objToDate = DateUtil.objToDate((Object)value);
                LocalDateTime localDateTime = objToDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                retobj = org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)localDateTime);
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: 
            case STRUCTURED_TYPE: 
            case DISTINCT_TYPE: 
            case RAW: 
            case SYMBOL: 
            case UNRESOLVED: {
                throw new UnsupportedOperationException();
            }
            default: {
                retobj = value;
            }
        }
        Object retobj2 = retobj;
        return (T)retobj2;
    }

    public String[] getLogicType() {
        return this.logicType;
    }

    public ListenerConf.ColumnType getColumnType() {
        return this.columnType;
    }

    public int getSqlType() {
        String dataTypeStr = this.getConvert().getDataTypeStr();
        if (dataTypeStr == null) {
            return 12;
        }
        int ret = 12;
        switch (dataTypeStr) {
            case "STRING": {
                ret = 12;
                break;
            }
            case "DECIMAL": {
                ret = 3;
                break;
            }
            case "BYTES": {
                ret = -2;
                break;
            }
            case "BOOLEAN": {
                ret = 16;
                break;
            }
            case "TINYINT": {
                ret = -6;
                break;
            }
            case "SMALLINT": {
                ret = 5;
                break;
            }
            case "FLOAT": {
                ret = 6;
                break;
            }
            case "DATE": {
                ret = 91;
                break;
            }
            case "TIME": {
                ret = 92;
                break;
            }
            case "TIMESTAMP_LTZ": {
                ret = 2014;
                break;
            }
            case "TIMESTAMP": {
                ret = 93;
                break;
            }
            case "INT": {
                ret = 4;
                break;
            }
            case "ROW": {
                ret = 12;
                break;
            }
        }
        return ret;
    }

    public static FlinkTypeEnum getByDataType(String dataTypeStr) {
        if (StringUtils.isEmpty((CharSequence)dataTypeStr)) {
            return VARCHAR;
        }
        for (FlinkTypeEnum ele : FlinkTypeEnum.values()) {
            if (!dataTypeStr.equalsIgnoreCase(ele.getConvert().getDataTypeStr())) continue;
            return ele;
        }
        return VARCHAR;
    }

    public static FlinkTypeEnum getByColumnType(ListenerConf.ColumnType columnType) {
        FlinkTypeEnum retojb = null;
        switch (columnType) {
            case VARCHAR: {
                retojb = VARCHAR;
                break;
            }
            case DECIMAL: {
                retojb = DECIMAL;
                break;
            }
            case TINY: {
                retojb = TINYINT;
                break;
            }
            case INT24: {
                retojb = INTEGER;
                break;
            }
            case SHORT: {
                retojb = SMALLINT;
                break;
            }
            case LONG: 
            case LONGLONG: {
                retojb = BIGINT;
                break;
            }
            case FLOAT: {
                retojb = FLOAT;
                break;
            }
            case DOUBLE: {
                retojb = DOUBLE;
                break;
            }
            case TIMESTAMP: {
                retojb = TIMESTAMP_WITHOUT_TIME_ZONE;
                break;
            }
            case DATE: {
                retojb = DATE;
                break;
            }
            case TIME: {
                retojb = TIME_WITHOUT_TIME_ZONE;
                break;
            }
            case DATETIME: {
                retojb = TIMESTAMP_WITH_LOCAL_TIME_ZONE;
                break;
            }
            case YEAR: {
                retojb = INTEGER;
                break;
            }
            case NEWDATE: {
                retojb = DATE;
                break;
            }
            case BIT: {
                retojb = VARCHAR;
                break;
            }
            case TIMESTAMP2: {
                retojb = VARCHAR;
                break;
            }
            case DATETIME2: {
                retojb = VARCHAR;
                break;
            }
            case TIME2: {
                retojb = VARCHAR;
                break;
            }
            case JSON: {
                retojb = VARCHAR;
                break;
            }
            case NEWDECIMAL: {
                retojb = VARCHAR;
                break;
            }
            case ENUM: {
                retojb = VARCHAR;
                break;
            }
            case SET: {
                retojb = VARCHAR;
                break;
            }
            case TINY_BLOB: {
                retojb = VARCHAR;
                break;
            }
            case MEDIUM_BLOB: {
                retojb = VARCHAR;
                break;
            }
            case LONG_BLOB: {
                retojb = VARCHAR;
                break;
            }
            case BLOB: {
                retojb = VARCHAR;
                break;
            }
            case VAR_STRING: {
                retojb = VARCHAR;
                break;
            }
            case STRING: {
                retojb = VARCHAR;
                break;
            }
            default: {
                retojb = VARCHAR;
            }
        }
        return retojb;
    }

    public Object getRowDataValue(GenericRow record, int pos, LogicalType logicalType) {
        if (record.isNullAt(pos)) {
            return null;
        }
        switch (this) {
            case BOOLEAN: {
                return record.getBoolean(pos) ? 1L : 0L;
            }
            case TINYINT: {
                return record.getByte(pos);
            }
            case SMALLINT: {
                return record.getShort(pos);
            }
            case INTEGER: {
                return record.getInt(pos);
            }
            case BIGINT: {
                return record.getLong(pos);
            }
            case FLOAT: {
                return Float.valueOf(record.getFloat(pos));
            }
            case DOUBLE: {
                return record.getDouble(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return record.getString(pos).toString();
            }
            case DATE: {
                return DateFormatCase.TZyyyyMMddHHmmss.getInstanc().format(Date.valueOf(LocalDate.ofEpochDay(record.getInt(pos))));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = 3;
                return DateFormatCase.TZyyyyMMddHHmmss.getInstanc().format(new java.util.Date(record.getTimestamp(pos, timestampPrecision).getMillisecond()));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType zonedTimestampType = (LocalZonedTimestampType)logicalType;
                return record.getTimestamp(pos, zonedTimestampType.getPrecision());
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return record.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale()).toBigDecimal();
            }
        }
        throw new UnsupportedOperationException("\u8fd8\u6ca1\u6709\u652f\u6301\u6b64\u7c7b\u578b\u7684\u83b7\u53d6\u503c:" + this.name());
    }

    public static String getStr(RowType.RowField rowField, GenericRow value, int pos) {
        FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.findByFlinkRowType(rowField.getType().getTypeRoot().toString());
        if (flinkTypeEnum == null) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_notfit, "\u5217\uff1a\u3010" + rowField.getName() + "\u3011\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u3010" + rowField.getType().getTypeRoot().toString() + "\u3011");
        }
        return flinkTypeEnum.getStringValue(value, pos, rowField.getType());
    }

    public static FlinkTypeEnum getBySqlExpression(String sqlExpression, FlinkTypeEnum oriColType) {
        FlinkTypeEnum retobj = oriColType;
        if (sqlExpression.startsWith("COUNT(")) {
            retobj = BIGINT;
        } else if (sqlExpression.startsWith("PROCTIME(")) {
            retobj = TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        } else if (sqlExpression.startsWith("LAST(")) {
            retobj = oriColType;
        }
        if (retobj == null) {
            retobj = VARCHAR;
        }
        return retobj;
    }

    public String getStringValue(GenericRow record, int pos, LogicalType logicalType) {
        Object rowDataValue = this.getRowDataValue(record, pos, logicalType);
        String retstr = null;
        if (rowDataValue == null) {
            return retstr;
        }
        retstr = rowDataValue instanceof java.util.Date ? DateFormatCase.TZyyyyMMddHHmmss.getInstanc().format(rowDataValue) : String.valueOf(rowDataValue);
        return retstr;
    }

    public int getDefaultPrecision() {
        return 38;
    }

    public int getDefaultScale() {
        return 4;
    }
}

