/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.FreemarkUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.http.HttpThread;
import org.apache.http.Header;

public abstract class JenkinsUtil {
    public static String getScriptGit(String repo, String branch) {
        String temp = "\r\n stage('git clone'){\r\n        //check CODE\r\n       git branch: '" + branch + "', credentialsId:'" + Conf.get((String)"common.others.jenkins.git.credentialsId") + "',url: '" + repo + "'\r\n}\r\n";
        return temp;
    }

    public static String getScriptBuild(Boolean isSkipTest) {
        if (isSkipTest == null) {
            isSkipTest = true;
        }
        String temp = "\r\n stage('mvn build'){\r\n        sh \"mvn clean install -Dmaven.test.skip=" + isSkipTest + "\"\r\n    }\r\n";
        return temp;
    }

    public static String getScriptDeploy() {
        String temp = "\r\n stage('docker build'){\r\n        sh \"mvn deploy \"\r\n    }\r\n";
        return temp;
    }

    public static String getScriptDockerBuild() {
        String temp = "\r\n stage('docker build'){\r\n        sh \"mvn ts:dockbuild\"\r\n    }\r\n";
        return temp;
    }

    public static String getScriptAddGit(String repo, String branch) {
        String temp = "\r\n stage('git push'){\r\n        sh \"mvn ts:addgit -Drepository=" + repo + " -Dbranch=" + branch + " \"\r\n    }\r\n";
        return temp;
    }

    public static String getScriptDockerPush(String group, String projectName, String tag) {
        String catalog = IOUtil.mergeFolderAndFilePath((String)group, (String[])new String[]{projectName});
        return JenkinsUtil.getScriptDockerPush(catalog, tag);
    }

    public static String getScriptDockerPush(String catalog, String tag) {
        String rep = IOUtil.mergeFolderAndFilePath((String)Conf.get((String)"common.others.docker.registry"), (String[])new String[]{catalog});
        String temp = "";
        temp = StringUtil.isNull((Object)tag) ? String.format("\r\n stage('docker push'){\r\n        sh \"mvn ts:dockpush -Drep=%s\"\r\n    }\r\n", rep) : String.format("\r\n stage('docker push'){\r\n        sh \"mvn ts:dockpush -Drep=%s -Dtag=%s\"\r\n    }\r\n", rep, tag);
        return temp;
    }

    public static String getScriptAddRc(String msgid, String namespace) {
        String callback = Conf.get((String)"common.others.jenkins.boom.callback");
        String temp = "\r\n stage('k8s addrc'){\r\n        sh \"mvn ts:addrc ";
        if (StringUtil.isNotNull((Object)msgid)) {
            temp = temp + String.format(" -Dcallback=%s  -Dmsgid=%s", callback, msgid);
        }
        if (StringUtil.isNotNull((Object)namespace)) {
            temp = temp + String.format(" -Dnamespace=%s", namespace);
        }
        temp = temp + "\"\r\n  }\r\n";
        return temp;
    }

    public static String getScriptAddSvc(String msgid, String namespace) {
        String callback = Conf.get((String)"common.others.jenkins.boom.callback");
        String temp = "\r\n stage('k8s addsvc'){\r\n        sh \"mvn ts:addsvc ";
        if (StringUtil.isNotNull((Object)msgid)) {
            temp = temp + String.format(" -Dcallback=%s  -Dmsgid=%s", callback, msgid);
        }
        if (StringUtil.isNotNull((Object)namespace)) {
            temp = temp + String.format(" -Dnamespace=%s", namespace);
        }
        temp = temp + "\"\r\n  }\r\n";
        return temp;
    }

    public static String getSucScript() {
        String temp = "\r\n stage('sucess'){\r\n        echo \"do all sucess ......\" \r\n  }\r\n";
        return temp;
    }

    public static String getTemp(String ... stages) {
        StringBuffer buff = new StringBuffer("node{\r\n");
        buff.append("def mvnHome = tool '" + Conf.get((String)"common.others.jenkins.tool.jdkid") + "'\r\n");
        buff.append("def jdkHome = tool '" + Conf.get((String)"common.others.jenkins.tool.mavenid") + "'\r\n");
        buff.append("env.PATH = \"${mvnHome}/bin:${jdkHome}/bin:${env.PATH}\"\r\n");
        for (String stage : stages) {
            buff.append(stage);
        }
        buff.append("}");
        return buff.toString();
    }

    public static Result createJob(String foldPath, String jobName, String configXML) {
        String url = IOUtil.mergeFolderAndFilePath((String)Conf.get((String)"common.others.jenkins.server.url"), (String[])new String[]{String.format("%screateItem?name=%s", JenkinsUtil.jobPathPar(foldPath), jobName)});
        return JenkinsUtil.doPost(url, configXML);
    }

    public static Result deleteJob(String jobpath) {
        String url = String.format("%s/%sdoDelete", Conf.get((String)"common.others.jenkins.server.url"), JenkinsUtil.jobPathPar(jobpath));
        return JenkinsUtil.doPost(url, null);
    }

    public static Result createFloder(String foldPath, String foldName, String displayName, String description) {
        String jobstr1 = JenkinsUtil.readJob(foldPath);
        if (jobstr1.contains("404")) {
            return Result.getError((String)("\u7236\u76ee\u5f55\u4e0d\u5b58\u5728:" + foldPath));
        }
        String path = IOUtil.mergeFolderAndFilePath((String)StringUtil.hasNull((String[])new String[]{foldPath, "/"}), (String[])new String[]{foldName});
        String jobstr2 = JenkinsUtil.readJob(path);
        if (jobstr2.contains("com.cloudbees.hudson.plugins.folder.Folder")) {
            return Result.getSuc((String)("\u6b64\u76ee\u5f55\u5df2\u5b58\u5728:" + path));
        }
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("displayName", StringUtil.hasNull((String[])new String[]{displayName, ""}));
        input.put("description", StringUtil.hasNull((String[])new String[]{description, ""}));
        String strtrue = FreemarkUtil.getInst().doProcess("floder.flt", input);
        return JenkinsUtil.createJob(foldPath, foldName, strtrue);
    }

    public static Result createFloder(String foldPathAll, String description, boolean isForce) {
        String foldPath;
        String jenkinspath = foldPathAll;
        jenkinspath = jenkinspath.endsWith("/") ? jenkinspath.substring(0, jenkinspath.length() - 1) : jenkinspath;
        jenkinspath = jenkinspath.startsWith("/") ? jenkinspath : "/" + jenkinspath;
        int index = jenkinspath.lastIndexOf("/");
        String name = jenkinspath.substring(index + 1);
        String string = foldPath = index == -1 ? null : jenkinspath.substring(0, index);
        if (isForce) {
            String[] split = foldPath.split("/");
            String root = "";
            for (String path : split) {
                if (StringUtil.isNull((boolean)false, (Object)path)) continue;
                Result createFloder = JenkinsUtil.createFloder(root, path, path, "auto create");
                root = root + "/" + path;
                if (createFloder.isSuc()) continue;
                return createFloder;
            }
        }
        return JenkinsUtil.createFloder(foldPath, name, name, description);
    }

    public static Result createPipeline(String foldPath, String jobName, String script) {
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("script", StringUtil.hasNull((String[])new String[]{script, ""}));
        String strtrue = FreemarkUtil.getInst().doProcess("pipeline.flt", input);
        return JenkinsUtil.createJob(foldPath, jobName, strtrue);
    }

    public static String readJob(String jobpath) {
        String temp = JenkinsUtil.jobPathPar(jobpath);
        String url = IOUtil.mergeFolderAndFilePath((String)Conf.get((String)"common.others.jenkins.server.url"), (String[])new String[]{String.format("%sconfig.xml", temp)});
        HttpResult http = HttpClient.doGet((String)url);
        String retstr = http.getBodyStr();
        return retstr;
    }

    public static Result stopBuild(String jobpath) {
        String url = String.format("%s/%s1/stop", Conf.get((String)"common.others.jenkins.server.url"), JenkinsUtil.jobPathPar(jobpath));
        return JenkinsUtil.doPost(url, null);
    }

    public static Result triggerBuild(String flowPath, String viewName) {
        String url = String.format("%s/%sview/%s/gridBuilder/build", Conf.get((String)"common.others.jenkins.server.url"), JenkinsUtil.jobPathPar(flowPath), viewName);
        return JenkinsUtil.doPost(url, null);
    }

    public static Result triggerBuild(String jobpath) {
        String url = String.format("%s/%sbuild", Conf.get((String)"common.others.jenkins.server.url"), JenkinsUtil.jobPathPar(jobpath));
        return JenkinsUtil.doPost(url, null);
    }

    public static List<String> listJobs(String folderpath) {
        String[] jobs;
        String url = String.format("%s/%sapi/xml", Conf.get((String)"common.others.jenkins.server.url"), JenkinsUtil.jobPathPar(folderpath));
        HttpThread thread = HttpClient.doPostXml((String)url, null, (Header[])new Header[0]);
        String jsonResponse = thread.call().getBodyStr();
        ArrayList<String> jobList = new ArrayList<String>();
        for (String job : jobs = jsonResponse.split("job>")) {
            String[] names = job.split("name>");
            if (names.length != 3) continue;
            String name = names[1];
            name = name.substring(0, name.length() - 2);
            jobList.add(name);
        }
        return jobList;
    }

    private static String jobPathPar(String jobpath) {
        String[] jobpathAry;
        if (StringUtil.isNull((Object)jobpath)) {
            return "";
        }
        StringBuffer temp = new StringBuffer();
        for (String job : jobpathAry = jobpath.split("\\/")) {
            if (!StringUtil.isNotNull((Object)job)) continue;
            temp.append(String.format("job/%s/", job));
        }
        String path = temp.toString();
        return path;
    }

    private static Result doPost(String url, String configXML) {
        HttpThread thread = HttpClient.doPostXml((String)url, (String)configXML, (Header[])new Header[0]);
        String retstr = thread.call().getBodyStr();
        if (StringUtil.isNull((Object)retstr)) {
            return Result.getSuc();
        }
        return Result.getError((String)"\u6267\u884c\u5931\u8d25").setRetObjs((Object[])new String[]{retstr});
    }

    static {
        ClassTemplateLoader classLoadLoader = new ClassTemplateLoader(JenkinsUtil.class, "/template/jenkins");
        FreemarkUtil.getInst().addLoads(new TemplateLoader[]{classLoadLoader});
    }
}

