/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.OSinfo;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClient {
    private static final Logger log = LoggerFactory.getLogger(ZkClient.class);
    private static ZkClient inst = new ZkClient();
    private final CuratorFramework curator;

    private ZkClient() {
        try {
            this.curator = CuratorFrameworkFactory.builder().defaultData(OSinfo.findIpAddressTrue().getBytes("UTF-8")).connectString(Conf.get((String)"common.others.zookeeper.constr")).sessionTimeoutMs(Integer.parseInt(Conf.get((String)"common.others.zookeeper.sleepTimeMs"))).connectionTimeoutMs(Integer.parseInt(Conf.get((String)"common.others.zookeeper.sessionTimeoutMs"))).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(Integer.parseInt(Conf.get((String)"common.others.zookeeper.sleepTimeMs")), Integer.parseInt(Conf.get((String)"common.others.zookeeper.maxRetries")))).build();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316client\u9519\u8bef");
        }
        this.curator.start();
    }

    public static ZkClient getInst() {
        return inst;
    }

    public Stat exists(String path) {
        try {
            return (Stat)this.curator.checkExists().forPath(path);
        }
        catch (Exception e) {
            log.error("\u67e5\u627etask\u914d\u7f6e\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public Result watchPath(String path, Watcher watcher) {
        try {
            ((ErrorListenerPathable)((BackgroundPathable)this.curator.getData().usingWatcher(watcher)).inBackground()).forPath(path);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u89c2\u5bdf\u9519\u8bef", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }

    public InterProcessMutex lockPath(String path, Long awaitTime) {
        InterProcessMutex retLock = new InterProcessMutex(this.curator, path);
        try {
            if (awaitTime == null) {
                long await = Long.parseLong(Conf.get((String)"common.others.zookeeper.lock.awaitTime"));
                retLock.acquire(await, TimeUnit.MILLISECONDS);
            } else if (awaitTime == -1L) {
                retLock.acquire();
            } else {
                retLock.acquire(awaitTime.longValue(), TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            return null;
        }
        return retLock;
    }

    public InterProcessMutex lockPathDefalutTime(String path) {
        return this.lockPath(path, null);
    }

    public InterProcessMutex lockPathBlock(String path) {
        return this.lockPath(path, -1L);
    }

    public List<String> lockValueList(InterProcessMutex interProcessMutex) {
        try {
            ArrayList<String> retlist = new ArrayList<String>();
            Collection values = interProcessMutex.getParticipantNodes();
            for (String value : values) {
                String val = this.getZkDataStr(value);
                retlist.add(val);
            }
            return retlist;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9501\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public PathChildrenCache createPathChildrenCache(String path, PathChildrenCacheListener children) {
        try {
            PathChildrenCache childrenCache = new PathChildrenCache(this.curator, path, true);
            childrenCache.getListenable().addListener((Object)children);
            childrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
            return childrenCache;
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u89c2\u5bdf\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public List<String> getChildren(String path) {
        try {
            List colsTables = (List)this.curator.getChildren().forPath(path);
            return colsTables;
        }
        catch (Exception e) {
            log.error("\u67e5\u770b\u5b50\u8282\u70b9\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public String createNode(String path, String value, boolean isTemp) {
        if (StringUtil.isNull((Object)(path = StringUtil.trimSpace((String)path)))) {
            return null;
        }
        value = StringUtil.isNull((Object)(value = StringUtil.trimSpace((String)value))) ? null : value;
        try {
            String pathret = null;
            CreateBuilder create = this.curator.create();
            if (isTemp) {
                create.withProtection().withMode(CreateMode.EPHEMERAL);
            }
            pathret = value == null ? (String)create.forPath(path) : (String)create.forPath(path, value.getBytes("UTF-8"));
            return pathret;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7ed3\u70b9\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public String createNode(String path, String value) {
        return this.createNode(path, value, false);
    }

    public Stat updateNode(String path, String data) {
        try {
            return (Stat)this.curator.setData().forPath(path, data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6570\u636e\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public Result createOrUpdateNode(String path, String data) {
        try {
            Stat stat = (Stat)this.curator.checkExists().forPath(path);
            if (stat == null) {
                String retpath = this.createNode(path, data);
                if (retpath == null) {
                    return Result.getError((String)"\u521b\u5efa\u8282\u70b9\u9519\u8bef");
                }
            } else {
                Stat statret = this.updateNode(path, data);
                if (statret == null) {
                    return Result.getError((String)"\u66f4\u65b0\u8282\u70b9\u9519\u8bef");
                }
            }
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6570\u636e\u9519\u8bef", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }

    public <T> Result createOrUpdateNodeForJson(String path, T obj) {
        String jsonstr = JSONObject.toJSONString(obj);
        return this.createOrUpdateNode(path, jsonstr);
    }

    public void createMultilevelNode(String path) {
        if (StringUtil.isNull((Object)path) || !path.startsWith("/")) {
            throw new IllegalArgumentException("path\u9519\u8bef");
        }
        path = path.replace("\\", "/");
        String[] paths = path.split("/");
        try {
            for (String ele : paths) {
                if (StringUtil.isNull((Object)ele)) continue;
                String tempstr = "/" + ele;
                int idx = path.indexOf(tempstr);
                String tempPath = path.substring(0, idx + tempstr.length());
                Stat stat = (Stat)this.curator.checkExists().forPath(tempPath);
                if (stat != null) continue;
                this.curator.create().forPath(tempPath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getZkDataStr(String path) {
        try {
            byte[] databin = (byte[])this.curator.getData().forPath(path);
            return new String(databin, "UTF-8");
        }
        catch (Exception e) {
            log.error("\u67e5\u627etask\u914d\u7f6e\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public <T> T getDateObj(String path, Class<T> clazz) {
        String data = this.getZkDataStr(path);
        return (T)JSONObject.parseObject((String)(StringUtil.isNull((Object)data) ? "{}" : data), clazz);
    }

    public Result deleteNode(String path) {
        try {
            this.curator.delete().forPath(path);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6570\u636e\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u5220\u9664\u6570\u636e\u9519\u8bef:" + e.getMessage()));
        }
    }

    public JSONObject getZkData(String path) {
        return JSONObject.parseObject((String)this.getZkDataStr(path));
    }
}

