package net.wicp.tams.common.others.util;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;

public class AcsClientCreator implements ObjectCreator<IAcsClient> {

	@Override
	public IAcsClient createObject() {
		IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou",
				Conf.get("common.others.aliyun.server.accesskey"), Conf.get("common.others.aliyun.server.secretkey"));
		IAcsClient client = new DefaultAcsClient(profile);
		return client;
	}

}