package net.wicp.tams.common.others.hibernate;

import java.io.Serializable;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Example.PropertySelector;

import net.wicp.tams.common.web.PageAssist;

/****
 * Hibernate辅助类,拥有事务
 *
 * @author Administrator
 *
 */
@SuppressWarnings("rawtypes")
public interface IHbService {

	/***
	 * 跟据ID查找对象
	 * 
	 * @param clazz
	 *            返回对象的类型
	 * @param id
	 *            id
	 * @return 查找的对象
	 */
	public <T extends Serializable> T findById(Class clazz, Serializable id);

	/***
	 * 跟据ID删除对象
	 * 
	 * @param clazz
	 *            返回对象的类型
	 * @param entityId
	 *            id
	 */
	void delById(Class clazz, Serializable entityId);

	/***
	 * 保存或新增PO对象
	 * 
	 * @param obj
	 *            要保存的对象
	 */
	public <T extends Serializable> void saveOrUpdate(T obj);

	/****
	 * Oracle/mysql 支持悲观锁的会用 select * from XXX for update 锁记录，其它数据库同 attachQuery
	 *
	 * @param entity
	 *            要锁的对象
	 */
	public <T extends Serializable> void attachLock(T entity);

	/***
	 * 跟据hql语句得到Query对象
	 * 
	 * @param hql
	 *            要查询的sql
	 * @return 查询对象
	 */
	public Query getQuery(String hql);

	/***
	 * 跟据sql得到Query对象
	 *
	 * @param sql
	 *            要查询的sql
	 * @return 查询对象
	 */
	public Query getQuerySQL(String sql);

	/***
	 * 通过示例查询，注意它会忽略 主键
	 *
	 * @param entity
	 *            要查询示例
	 * @param selector
	 *            selector
	 * @return 查询结果
	 */
	public <T extends Serializable> List<T> findByExample(T entity, PropertySelector selector);

	/***
	 * 通过示例查询，注意它会忽略 主键
	 *
	 * @param entity
	 *            要查询示例
	 * @param excludes
	 *            示例中被排除的查询条件
	 * @return 查询结果
	 */
	public <T extends Serializable> List<T> findByExample(T entity, String... excludes);

	/****
	 * 通过requesty请求来构建翻页
	 * 
	 * @param criteria
	 *            查询条件
	 * @param request
	 *            请求
	 * @return 翻页对象
	 */
	public PageAssist findByCriteriaPage(Criteria criteria, HttpServletRequest request);

	public PageAssist findByCriteriaPage(Criteria criteria, PageAssist reqPageAssist);

	/***
	 * Query的翻页查询，PageAssist由系统默认生成
	 * 
	 * @param queryparam
	 *            查询条件
	 * @return 翻页对象
	 */
	public PageAssist findByQueryPage(Query queryparam, HttpServletRequest request);

	public PageAssist findByQueryPage(Query queryparam, PageAssist reqPageAssist);

	/****
	 * 得到当前的session
	 * 
	 * @return 当前的session
	 */
	public Session getSession();

}
