package net.wicp.tams.common.others.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.others.JenkinsUtil;

public enum DeployType implements IEnumCombobox {
	jar("二方库"),

	docker("docker"), // 只打docker并推送到注册中心

	rc("对内服务"), // 只发rc

	svc("对外服务"); // 需要发布服务k8s_svc

	private final String desc;

	private DeployType(String desc) {
		this.desc = desc;
	}

	/***
	 * common:repo/branch/skipTest
	 * 
	 * 得到script
	 * 
	 * @param deployType
	 * @param params
	 * @return
	 */
	public static String getJenkinsScript(DeployType deployType, Map<DeployTypeParam, String> params,
			String namespace) {
		List<String> stages = new ArrayList<>();
		stages.add(JenkinsUtil.getScriptGit(params.get(DeployTypeParam.repo), params.get(DeployTypeParam.branch)));
		stages.add(JenkinsUtil.getScriptBuild(params.get(DeployTypeParam.skipTest) == null ? null
				: Boolean.parseBoolean(params.get(DeployTypeParam.skipTest))));
		switch (deployType) {
		case jar:
			stages.add(JenkinsUtil.getScriptDeploy());
			break;
		case docker:
			stages.add(JenkinsUtil.getScriptDockerBuild());
			stages.add(JenkinsUtil.getScriptDockerPush(params.get(DeployTypeParam.catalog),
					params.get(DeployTypeParam.tag)));
			break;
		case rc:
			stages.add(JenkinsUtil.getScriptDockerBuild());
			stages.add(JenkinsUtil.getScriptDockerPush(params.get(DeployTypeParam.catalog),
					params.get(DeployTypeParam.tag)));
			stages.add(JenkinsUtil.getScriptAddRc(params.get(DeployTypeParam.msgid), namespace));
			break;
		case svc:
			stages.add(JenkinsUtil.getScriptDockerBuild());
			stages.add(JenkinsUtil.getScriptDockerPush(params.get(DeployTypeParam.catalog),
					params.get(DeployTypeParam.tag)));
			stages.add(JenkinsUtil.getScriptAddRc(params.get(DeployTypeParam.msgid), namespace));
			stages.add(JenkinsUtil.getScriptAddSvc(params.get(DeployTypeParam.msgid), namespace));
			break;
		default:
			break;
		}
		return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
	}

	/***
	 * 得到测试环境后的script
	 * 
	 * @param deployType
	 * @param params
	 * @param namespace
	 *            pre:预发 pro:生产
	 * @return
	 */
	public static String getJenkinsScriptAfterTest(DeployType deployType, Map<DeployTypeParam, String> params,
			String namespace) {
		if ("pro".equals(namespace)) {
			namespace = "default";
		}
		List<String> stages = new ArrayList<>();
		stages.add(JenkinsUtil.getScriptGit(params.get(DeployTypeParam.repo), params.get(DeployTypeParam.branch)));
		switch (deployType) {
		case rc:
			stages.add(JenkinsUtil.getScriptAddRc(params.get(DeployTypeParam.msgid), namespace));
			break;
		case svc:
			stages.add(JenkinsUtil.getScriptAddRc(params.get(DeployTypeParam.msgid), namespace));
			stages.add(JenkinsUtil.getScriptAddSvc(params.get(DeployTypeParam.msgid), namespace));
			break;
		default:
			return null;
		}
		return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
	}
	public static String getJenkinsScriptMerge(String repo,String branch) {
		Map<DeployTypeParam, String> params =new HashMap<DeployTypeParam, String>();
		params.put(DeployTypeParam.repo, repo);
		params.put(DeployTypeParam.branch, branch);
		List<String> stages = new ArrayList<>();
		stages.add(JenkinsUtil.getScriptGit(params.get(DeployTypeParam.repo), params.get(DeployTypeParam.branch)));
		stages.add(JenkinsUtil.getScriptAddGit(params.get(DeployTypeParam.repo),params.get(DeployTypeParam.branch)));
		return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
	}
	

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.desc;
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}
}
