package net.wicp.tams.common.others;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.kafka.clients.consumer.KafkaConsumer;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;

@Slf4j
public class KafkaUtil {

	private  static KafkaUtil inst = new KafkaUtil();

	private KafkaUtil() {
	}

	public static KafkaUtil getInst() {
		return inst;
	}

	private Map<String, String> nameToType = new HashMap<>();
	{
		nameToType.put("retries", "integer");
		nameToType.put("max.block.ms", "long");
		nameToType.put("max.in.flight.requests.per.connection", "integer");
		nameToType.put("linger.ms", "integer");
		nameToType.put("batch.size", "integer");
		nameToType.put("buffer.memory", "integer");
		nameToType.put("max.request.size", "integer");
		nameToType.put("receive.buffer.bytes", "integer");
		nameToType.put("request.timeout.ms", "integer");
		nameToType.put("send.buffer.bytes", "integer");
		nameToType.put("connections.max.idle.ms", "integer");
	}

	public KafkaConsumer<String, byte[]> createConsumer() {
		Properties prop = initProps();
		log.info("kafka参数:");
		for (Object propele : prop.keySet()) {
			log.info("{}:{}", propele, prop.get(propele));
		}
		prop.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
		prop.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
		
		
		prop.put("group.id", "group3");  
		
		// link和batch不用加
		KafkaConsumer<String, byte[]> consumer = new KafkaConsumer<>(prop);
		return consumer;
	}

	private Properties initProps() {
		Map<String, String> paramsMap = Conf.getPre("common.others.kafka.", true);
		Properties prop = new Properties();
		for (String key : paramsMap.keySet()) {
			if (StringUtil.isNotNull(paramsMap.get(key))) {
				if (nameToType.containsKey(key)) {
					if ("integer".equals(nameToType.get(key))) {
						prop.put(key, Integer.parseInt(paramsMap.get(key)));
					} else if ("long".equals(nameToType.get(key))) {
						prop.put(key, Long.parseLong(paramsMap.get(key).replace("l", "").replace("L", "")));
					}
				} else {
					prop.put(key, paramsMap.get(key));
				}

			}
		}
		return prop;
	}

}
