/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.others.kafka.KafkaAssitInst;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;

public abstract class KafkaTools {
    private static Properties propProducer = null;
    private static Properties propConsumer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProps(boolean isProducer) {
        if (isProducer && propProducer == null || !isProducer && propConsumer == null) {
            Object object = new Object();
            synchronized (object) {
                Properties temp = new Properties();
                HashMap<String, String> nameToType = new HashMap<String, String>();
                nameToType.put("retries", "integer");
                nameToType.put("max.block.ms", "long");
                nameToType.put("max.in.flight.requests.per.connection", "integer");
                nameToType.put("linger.ms", "integer");
                nameToType.put("batch.size", "integer");
                nameToType.put("buffer.memory", "integer");
                nameToType.put("max.request.size", "integer");
                nameToType.put("receive.buffer.bytes", "integer");
                nameToType.put("request.timeout.ms", "integer");
                nameToType.put("send.buffer.bytes", "integer");
                nameToType.put("connections.max.idle.ms", "integer");
                Map paramsMap = Conf.getPre((String)("common.others.kafka." + (isProducer ? "producer." : "consumer.")), (boolean)true);
                paramsMap.putAll(Conf.getPre((String)"common.others.kafka.common.", (boolean)true));
                for (String key : paramsMap.keySet()) {
                    if (!StringUtil.isNotNull(paramsMap.get(key))) continue;
                    if (nameToType.containsKey(key)) {
                        if ("integer".equals(nameToType.get(key))) {
                            temp.put(key, (Object)Integer.parseInt((String)paramsMap.get(key)));
                            continue;
                        }
                        if (!"long".equals(nameToType.get(key))) continue;
                        temp.put(key, (Object)Long.parseLong(((String)paramsMap.get(key)).replace("l", "").replace("L", "")));
                        continue;
                    }
                    temp.put(key, paramsMap.get(key));
                }
                if (isProducer) {
                    propProducer = temp;
                } else {
                    propConsumer = temp;
                }
            }
        }
        return isProducer ? (Properties)propProducer.clone() : (Properties)propConsumer.clone();
    }

    public static String getValueProp(Class<?> classz, boolean isProducer) {
        if ("java.lang.String".equals(classz.getName())) {
            return isProducer ? "org.apache.kafka.common.serialization.StringSerializer" : "org.apache.kafka.common.serialization.StringDeserializer";
        }
        if ("[B".equals(classz.getName())) {
            return isProducer ? "org.apache.kafka.common.serialization.ByteArraySerializer" : "org.apache.kafka.common.serialization.ByteArrayDeserializer";
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
    }

    public static <T> void errorlog(ConsumerRecords<String, T> consumerRecords, Result doWithRecord, Logger log) {
        if (!doWithRecord.isSuc()) {
            int i = 0;
            for (ConsumerRecord item : consumerRecords) {
                if (ArrayUtils.isEmpty((Object[])doWithRecord.retObjs())) {
                    log.error("\u5904\u7406\u51fa\u9519\u4e86,\u6253\u5370\u6b64\u6279\u6b21: topic:[{}],partition:[{}],offset:[{}]", new Object[]{item.topic(), item.partition(), item.offset()});
                } else if (doWithRecord.retObjs().length > i && doWithRecord.retObjs()[i] != null) {
                    log.error("\u5904\u7406\u51fa\u9519\u4e86,\u51fa\u9519\u8bb0\u5f55: topic:[{}],partition:[{}],offset:[{}] \uff0c\u51fa\u9519\u539f\u56e0\u3010{}\u3011", new Object[]{item.topic(), item.partition(), item.offset(), doWithRecord.retObjs()[i]});
                }
                ++i;
            }
        }
    }

    public static List<TopicPartition> getTopicPartition(String topic) {
        KafkaProducer<String, byte[]> kafkaProducer = KafkaAssitInst.getInst().getKafkaProducer(byte[].class);
        List partitionsFor = kafkaProducer.partitionsFor(topic);
        ArrayList<TopicPartition> retlist = new ArrayList<TopicPartition>();
        for (PartitionInfo partitionInfo : partitionsFor) {
            TopicPartition pation = new TopicPartition(topic, partitionInfo.partition());
            retlist.add(pation);
        }
        return retlist;
    }
}

