/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogBackUtil {
    private static final Logger log = LoggerFactory.getLogger(LogBackUtil.class);
    private static final LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();

    public static ch.qos.logback.classic.Logger getRoot() {
        return context.getLogger("ROOT");
    }

    public static RollingFileAppender<ILoggingEvent> newFileAppender(String filePath, PatternLayoutEncoder filePattern, TimeBasedRollingPolicy<ILoggingEvent> rollingPolicy) {
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setContext((Context)context);
        fileAppender.setFile(filePath);
        rollingPolicy.setParent((FileAppender)fileAppender);
        fileAppender.setRollingPolicy(rollingPolicy);
        rollingPolicy.start();
        fileAppender.setEncoder((Encoder)filePattern);
        filePattern.start();
        fileAppender.start();
        return fileAppender;
    }

    public static RollingFileAppender<ILoggingEvent> newFileAppender(String filePath, String encoderPattern, String fileNamePattern, int maxHistory) {
        PatternLayoutEncoder filePattern = LogBackUtil.buildEncoder(encoderPattern);
        TimeBasedRollingPolicy<ILoggingEvent> rollingPolicy = LogBackUtil.buildRollingPolicy(fileNamePattern, maxHistory);
        RollingFileAppender<ILoggingEvent> fileAppender = LogBackUtil.newFileAppender(filePath, filePattern, rollingPolicy);
        return fileAppender;
    }

    public static PatternLayoutEncoder buildEncoder(String pattern) {
        PatternLayoutEncoder filePattern = new PatternLayoutEncoder();
        filePattern.setContext((Context)context);
        filePattern.setCharset(Charset.forName("UTF-8"));
        filePattern.setPattern(pattern);
        return filePattern;
    }

    public static TimeBasedRollingPolicy<ILoggingEvent> buildRollingPolicy(String fileNamePattern, int maxHistory) {
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setFileNamePattern(fileNamePattern);
        rollingPolicy.setMaxHistory(maxHistory);
        return rollingPolicy;
    }

    public static void logDebugTime(Logger loginput, String info, long beginTime) {
        if (loginput == null) {
            loginput = log;
        }
        if (loginput.isDebugEnabled()) {
            loginput.debug(String.format("time:info:[%s] begin:[%s] used:[%s] ", info, beginTime, System.currentTimeMillis() - beginTime));
        }
    }

    public static void logDebugTime(String info, long beginTime) {
        LogBackUtil.logDebugTime(null, info, beginTime);
    }
}

