/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others.docker;

import io.fabric8.docker.client.Config;
import io.fabric8.docker.client.ConfigBuilder;
import io.fabric8.docker.client.DefaultDockerClient;
import io.fabric8.docker.client.DockerClient;
import io.fabric8.docker.client.EditableConfig;
import io.fabric8.docker.dsl.EventListener;
import io.fabric8.docker.dsl.OutputHandle;
import io.fabric8.docker.dsl.image.ForceTagNameInterface;
import io.fabric8.docker.dsl.image.ForceToRegistryInterface;
import io.fabric8.docker.dsl.image.ImageInspectPullHistoryPushTagDeleteGetLoadInterface;
import io.fabric8.docker.dsl.image.InRepositoryForceTagNameInterface;
import io.fabric8.docker.dsl.image.RedirectingWritingOutputFromPathInterface;
import io.fabric8.docker.dsl.image.RedirectingWritingOutputTagForceToRegistryInterface;
import io.fabric8.docker.dsl.image.RepositoryNameSupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface;
import io.fabric8.docker.dsl.image.SupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface;
import io.fabric8.docker.dsl.image.UsingListenerRedirectingWritingOutputTagForceToRegistryInterface;
import io.fabric8.docker.dsl.image.WithTagNameInterface;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerUtil {
    private static final Logger log = LoggerFactory.getLogger(DockerUtil.class);
    private static DockerUtil inst = new DockerUtil();
    private final DockerClient docker;

    public DockerClient getDocker() {
        return this.docker;
    }

    private DockerUtil() {
        String url = Conf.get((String)"common.others.docker.url");
        log.info("\u542f\u7528\u7684docker\u5730\u5740\u662f\uff1a\u3010{}\u3011", (Object)url);
        EditableConfig config = ((ConfigBuilder)new ConfigBuilder().withDockerUrl(url)).build();
        this.docker = new DefaultDockerClient((Config)config);
    }

    public static DockerUtil getInst() {
        return inst;
    }

    public Result buildImage(String imageFolder, String image) {
        log.info("buildImage,imageFolder:[{}],image:[{}]", (Object)imageFolder, (Object)image);
        final Result ret = Result.getError((String)"");
        try {
            final CountDownLatch buildDone = new CountDownLatch(1);
            OutputHandle handle = (OutputHandle)((RedirectingWritingOutputFromPathInterface)((SupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface)((RepositoryNameSupressingVerboseOutputNoCachePullingRemoveIntermediateMemorySwapCpuSharesCpusPeriodQuotaBuildArgsUsingDockerFileListenerRedirectingWritingFromPathInterface)this.docker.image().build()).withRepositoryName(image)).usingListener(new EventListener(){

                public void onSuccess(String message) {
                    log.info("\u6210\u529f\u6253doccker image:{}", (Object)message);
                    buildDone.countDown();
                    ret.setMessage("ok");
                }

                public void onError(String messsage) {
                    log.error("Failure:" + messsage);
                    buildDone.countDown();
                    ret.setMessage(messsage);
                }

                public void onError(Throwable t) {
                    log.error("Failure", t);
                    buildDone.countDown();
                    ret.setMessage(t.getMessage());
                }

                public void onEvent(String event) {
                }
            })).fromFolder(imageFolder);
            buildDone.await(30L, TimeUnit.SECONDS);
            handle.close();
            return "ok".equals(ret.getMessage()) ? Result.getSuc() : ret;
        }
        catch (Exception e) {
            log.error("build\u5931\u8d25", (Throwable)e);
            ret.setMessage(e.getMessage());
            return ret;
        }
    }

    public Result pushImage(String image, String repositoryName, String tagName) {
        final Result ret = Result.getError((String)"");
        try {
            final CountDownLatch pushDone = new CountDownLatch(1);
            ((WithTagNameInterface)((ForceTagNameInterface)((InRepositoryForceTagNameInterface)((ImageInspectPullHistoryPushTagDeleteGetLoadInterface)this.docker.image().withName(image)).tag()).inRepository(repositoryName)).force()).withTagName(tagName);
            OutputHandle handle = (OutputHandle)((ForceToRegistryInterface)((RedirectingWritingOutputTagForceToRegistryInterface)((UsingListenerRedirectingWritingOutputTagForceToRegistryInterface)((ImageInspectPullHistoryPushTagDeleteGetLoadInterface)this.docker.image().withName(repositoryName)).push()).usingListener(new EventListener(){

                public void onSuccess(String message) {
                    log.info("push success:{}", (Object)message);
                    pushDone.countDown();
                    ret.setMessage("ok");
                }

                public void onError(String messsage) {
                    log.error("Failure:" + messsage);
                    pushDone.countDown();
                    ret.setMessage(messsage);
                }

                public void onError(Throwable t) {
                    log.error("Failure", t);
                    pushDone.countDown();
                    ret.setMessage(t.getMessage());
                }

                public void onEvent(String event) {
                }
            })).withTag(tagName)).toRegistry();
            pushDone.await(30L, TimeUnit.SECONDS);
            handle.close();
            return "ok".equals(ret.getMessage()) ? Result.getSuc() : ret;
        }
        catch (Exception e) {
            log.error("build\u5931\u8d25", (Throwable)e);
            ret.setMessage(e.getMessage());
            return ret;
        }
    }

    public Result pushImageByCatalog(String image, String catalog, String tagName) {
        String repositoryName = IOUtil.mergeFolderAndFilePath((String)Conf.get((String)"common.others.docker.registry"), (String[])new String[]{catalog});
        return this.pushImage(image, repositoryName, tagName);
    }
}

