/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaUtil {
    private static final Logger log = LoggerFactory.getLogger(KafkaUtil.class);
    private static KafkaUtil inst = new KafkaUtil();
    private Map<String, String> nameToType = new HashMap<String, String>();

    private KafkaUtil() {
        this.nameToType.put("retries", "integer");
        this.nameToType.put("max.block.ms", "long");
        this.nameToType.put("max.in.flight.requests.per.connection", "integer");
        this.nameToType.put("linger.ms", "integer");
        this.nameToType.put("batch.size", "integer");
        this.nameToType.put("buffer.memory", "integer");
        this.nameToType.put("max.request.size", "integer");
        this.nameToType.put("receive.buffer.bytes", "integer");
        this.nameToType.put("request.timeout.ms", "integer");
        this.nameToType.put("send.buffer.bytes", "integer");
        this.nameToType.put("connections.max.idle.ms", "integer");
    }

    public static KafkaUtil getInst() {
        return inst;
    }

    public KafkaConsumer<String, byte[]> createConsumer() {
        Properties prop = this.initProps();
        log.info("kafka\u53c2\u6570:");
        for (Object propele : prop.keySet()) {
            log.info("{}:{}", propele, prop.get(propele));
        }
        prop.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        prop.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        prop.put("group.id", "group3");
        KafkaConsumer consumer = new KafkaConsumer(prop);
        return consumer;
    }

    private Properties initProps() {
        Map paramsMap = Conf.getPre((String)"common.others.kafka.", (boolean)true);
        Properties prop = new Properties();
        for (String key : paramsMap.keySet()) {
            if (!StringUtil.isNotNull(paramsMap.get(key))) continue;
            if (this.nameToType.containsKey(key)) {
                if ("integer".equals(this.nameToType.get(key))) {
                    prop.put(key, (Object)Integer.parseInt((String)paramsMap.get(key)));
                    continue;
                }
                if (!"long".equals(this.nameToType.get(key))) continue;
                prop.put(key, (Object)Long.parseLong(((String)paramsMap.get(key)).replace("l", "").replace("L", "")));
                continue;
            }
            prop.put(key, paramsMap.get(key));
        }
        return prop;
    }
}

