/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.others.JenkinsUtil;
import net.wicp.tams.common.others.constant.DeployTypeParam;

public enum DeployType implements IEnumCombobox
{
    jar("\u4e8c\u65b9\u5e93"),
    docker("docker"),
    rc("\u5bf9\u5185\u670d\u52a1"),
    svc("\u5bf9\u5916\u670d\u52a1");

    private final String desc;

    private DeployType(String desc) {
        this.desc = desc;
    }

    public static String getJenkinsScript(DeployType deployType, Map<DeployTypeParam, String> params, String namespace) {
        ArrayList<String> stages = new ArrayList<String>();
        stages.add(JenkinsUtil.getScriptGit(params.get((Object)DeployTypeParam.repo), params.get((Object)DeployTypeParam.branch)));
        stages.add(JenkinsUtil.getScriptBuild(params.get((Object)DeployTypeParam.skipTest) == null ? null : Boolean.valueOf(Boolean.parseBoolean(params.get((Object)DeployTypeParam.skipTest)))));
        switch (deployType) {
            case jar: {
                stages.add(JenkinsUtil.getScriptDeploy());
                break;
            }
            case docker: {
                stages.add(JenkinsUtil.getScriptDockerBuild());
                stages.add(JenkinsUtil.getScriptDockerPush(params.get((Object)DeployTypeParam.catalog), params.get((Object)DeployTypeParam.tag)));
                break;
            }
            case rc: {
                stages.add(JenkinsUtil.getScriptDockerBuild());
                stages.add(JenkinsUtil.getScriptDockerPush(params.get((Object)DeployTypeParam.catalog), params.get((Object)DeployTypeParam.tag)));
                stages.add(JenkinsUtil.getScriptAddRc(params.get((Object)DeployTypeParam.msgid), namespace));
                break;
            }
            case svc: {
                stages.add(JenkinsUtil.getScriptDockerBuild());
                stages.add(JenkinsUtil.getScriptDockerPush(params.get((Object)DeployTypeParam.catalog), params.get((Object)DeployTypeParam.tag)));
                stages.add(JenkinsUtil.getScriptAddRc(params.get((Object)DeployTypeParam.msgid), namespace));
                stages.add(JenkinsUtil.getScriptAddSvc(params.get((Object)DeployTypeParam.msgid), namespace));
                break;
            }
        }
        return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
    }

    public static String getJenkinsScriptAfterTest(DeployType deployType, Map<DeployTypeParam, String> params, String namespace) {
        if ("pro".equals(namespace)) {
            namespace = "default";
        }
        ArrayList<String> stages = new ArrayList<String>();
        stages.add(JenkinsUtil.getScriptGit(params.get((Object)DeployTypeParam.repo), params.get((Object)DeployTypeParam.branch)));
        switch (deployType) {
            case rc: {
                stages.add(JenkinsUtil.getScriptAddRc(params.get((Object)DeployTypeParam.msgid), namespace));
                break;
            }
            case svc: {
                stages.add(JenkinsUtil.getScriptAddRc(params.get((Object)DeployTypeParam.msgid), namespace));
                stages.add(JenkinsUtil.getScriptAddSvc(params.get((Object)DeployTypeParam.msgid), namespace));
                break;
            }
            default: {
                return null;
            }
        }
        return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
    }

    public static String getJenkinsScriptMerge(String repo, String branch) {
        HashMap<DeployTypeParam, String> params = new HashMap<DeployTypeParam, String>();
        params.put(DeployTypeParam.repo, repo);
        params.put(DeployTypeParam.branch, branch);
        ArrayList<String> stages = new ArrayList<String>();
        stages.add(JenkinsUtil.getScriptGit((String)params.get((Object)DeployTypeParam.repo), (String)params.get((Object)DeployTypeParam.branch)));
        stages.add(JenkinsUtil.getScriptAddGit((String)params.get((Object)DeployTypeParam.repo), (String)params.get((Object)DeployTypeParam.branch)));
        return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
    }

    public String getName() {
        return this.name();
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.desc;
    }

    public String getDesc_zh() {
        return this.desc;
    }
}

