/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public abstract class RedisClient {
    private static Logger logger = LoggerFactory.getLogger(RedisClient.class);
    private static JedisPool jedisPool;
    private static int defautlDb;
    private static boolean initPool;
    private static final Object lockObj;

    public static Jedis getConnection() {
        RedisClient.init();
        Jedis retJedis = jedisPool.getResource();
        retJedis.select(defautlDb);
        return retJedis;
    }

    public static JedisPool getJedisPool() {
        RedisClient.init();
        return jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (jedisPool == null || initPool) {
            Object object = lockObj;
            synchronized (object) {
                initPool = false;
                if (jedisPool != null) {
                    jedisPool.destroy();
                }
                String name = "common.others.redisserver";
                Map confMap = Conf.getPre((String)name, (boolean)false);
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(Integer.parseInt((String)confMap.get(name + ".maxTotal")));
                config.setMaxIdle(Integer.parseInt((String)confMap.get(name + ".maxIdle")));
                config.setMinIdle(Integer.parseInt((String)confMap.get(name + ".minIdle")));
                config.setMinEvictableIdleTimeMillis((long)Integer.parseInt((String)confMap.get(name + ".minEvictableIdleTimeMillis")));
                config.setSoftMinEvictableIdleTimeMillis((long)Integer.parseInt((String)confMap.get(name + ".softMinEvictableIdleTimeMillis")));
                config.setNumTestsPerEvictionRun(Integer.parseInt((String)confMap.get(name + ".numTestsPerEvictionRun")));
                config.setTestOnReturn(Boolean.parseBoolean((String)confMap.get(name + ".testOnReturn")));
                config.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt((String)confMap.get(name + ".timeBetweenEvictionRunsMillis")));
                config.setBlockWhenExhausted(Boolean.parseBoolean((String)confMap.get(name + ".blockWhenExhausted")));
                config.setMaxWaitMillis((long)Integer.parseInt((String)confMap.get(name + ".maxWaitMillis")));
                config.setTestOnBorrow(Boolean.parseBoolean((String)confMap.get(name + ".testOnBorrow")));
                config.setTestWhileIdle(Boolean.parseBoolean((String)confMap.get(name + ".testWhileIdle")));
                defautlDb = confMap.get(name + ".defaultDb") == null ? 0 : Integer.parseInt((String)confMap.get(name + ".defaultDb"));
                String password = (String)confMap.get(name + ".password");
                jedisPool = StringUtils.isBlank((CharSequence)password) ? new JedisPool((GenericObjectPoolConfig)config, (String)confMap.get(name + ".host"), Integer.parseInt((String)confMap.get(name + ".port"))) : new JedisPool((GenericObjectPoolConfig)config, (String)confMap.get(name + ".host"), Integer.parseInt((String)confMap.get(name + ".port")), Integer.parseInt((String)confMap.get(name + ".maxWaitMillis")), password);
                logger.info("\u521d\u59cb\u5316\u6c60\u6210\u529f");
            }
        }
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            try {
                jedis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T extends Serializable> void putObjByMap(Jedis jedis, String key, T obj, Integer expire) {
        Map inpumap = ReflectAssist.convertMapFromBean(obj);
        jedis.hmset(key, inpumap);
        if (expire != null) {
            jedis.expire(key, expire.intValue());
        }
    }

    public static void destroy() {
        jedisPool.destroy();
        initPool = true;
    }

    public static <T extends Serializable> void putObjByMap(Jedis jedis, String key, T obj) {
        RedisClient.putObjByMap(jedis, key, obj, null);
    }

    public static final <T extends Serializable> void putObjByJson(Jedis jedis, T obj, String key, Integer expire) {
        String json = JSON.toJSONString(obj);
        jedis.set(key, json);
        if (expire != null) {
            jedis.expire(key, expire.intValue());
        }
    }

    public static final <T extends Serializable> void putObjByJson(Jedis jedis, T obj, String key) {
        RedisClient.putObjByJson(jedis, obj, key, null);
    }

    public static final <T extends Enum> void putEnumMap(Jedis jedis, String key, Map<T, String> inputMap) {
        if (jedis == null || MapUtils.isEmpty(inputMap) || StringUtil.isNull((Object)key)) {
            return;
        }
        HashMap<String, String> input = new HashMap<String, String>();
        for (Enum ele : inputMap.keySet()) {
            input.put(ele.name(), inputMap.get(ele));
        }
        jedis.hmset(key, input);
    }

    public static final <T extends Enum> Map<T, String> getEnumMap(Jedis jedis, String key, Class clazz) {
        T[] objs = clazz.getEnumConstants();
        String[] fields = new String[objs.length];
        for (int i = 0; i < fields.length; ++i) {
            Enum tempobj = (Enum)objs[i];
            fields[i] = tempobj.name();
        }
        List rets = jedis.hmget(key, fields);
        HashMap retobj = new HashMap();
        for (int i = 0; i < fields.length; ++i) {
            Enum curobj = null;
            for (Object object : objs) {
                Enum tempobj = (Enum)object;
                if (!fields[i].equals(tempobj.name())) continue;
                curobj = tempobj;
                break;
            }
            retobj.put(curobj, rets.get(i));
        }
        return retobj;
    }

    public static Map<String, String> getMapByField(Jedis jedis, String key, String ... fields) {
        HashMap<String, String> retobj = new HashMap<String, String>();
        if (jedis == null || StringUtil.isNull((Object)key) || ArrayUtils.isEmpty((Object[])fields) || !jedis.exists(key).booleanValue()) {
            return retobj;
        }
        List values = jedis.hmget(key, fields);
        if (ArrayUtils.isNotEmpty((Object[])fields) && CollectionUtils.isNotEmpty((Collection)values)) {
            for (int i = 0; i < fields.length; ++i) {
                retobj.put(fields[i], (String)values.get(i));
            }
        }
        return retobj;
    }

    public static <T extends Serializable> T getObjByMapValue(Class<T> clazz, Jedis jedis, String key, String ... fields) {
        if (ArrayUtils.isEmpty((Object[])fields)) {
            List classfields = ReflectAssist.findGetField(clazz);
            fields = classfields.toArray(new String[classfields.size()]);
        }
        Map<String, String> retmap = RedisClient.getMapByField(jedis, key, fields);
        Serializable rett = ReflectAssist.convertMapToBean(clazz, retmap);
        return (T)rett;
    }

    public static <T extends Serializable> T getObjByMapValue(Class<T> clazz, Jedis jedis, String key) {
        List list = ReflectAssist.findGetField(clazz);
        String[] array = list.toArray(new String[list.size()]);
        return RedisClient.getObjByMapValue(clazz, jedis, key, array);
    }

    public static <T extends Serializable> T getObjByJsonValue(Class<T> clazz, Jedis jedis, String key) {
        String jsonstr = jedis.get(String.valueOf(key));
        Serializable retobj = (Serializable)JSON.toJavaObject((JSON)JSON.parseObject((String)jsonstr), clazz);
        return (T)retobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T findByRedis(Class<T> calssz, String key) {
        Jedis jedis = RedisClient.getConnection();
        try {
            T t;
            T t2 = t = RedisClient.getObjByMapValue(calssz, jedis, key);
            return t2;
        }
        finally {
            RedisClient.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void putRedis(T saveobj, String key) {
        Jedis jedis = RedisClient.getConnection();
        try {
            RedisClient.putObjByMap(jedis, key, saveobj);
        }
        finally {
            RedisClient.returnResource(jedis);
        }
    }

    static {
        defautlDb = 0;
        initPool = false;
        lockObj = new Object();
    }
}

