/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public abstract class GitUtil {
    public static Git newBranch(Git git, String branchName, String user, String pwd) throws GitAPIException {
        String newBranchIndex = "refs/heads/" + branchName;
        List refs = git.branchList().call();
        for (Ref ref : refs) {
            if (!ref.getName().equals(newBranchIndex)) continue;
            System.out.println("Removing branch before");
            git.branchDelete().setBranchNames(new String[]{branchName}).setForce(true).call();
            break;
        }
        Ref ref = git.branchCreate().setName(branchName).call();
        UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(GitUtil.getUser(user), GitUtil.getPwd(pwd));
        ((PushCommand)git.push().add(ref).setCredentialsProvider((CredentialsProvider)cp)).call();
        return git;
    }

    public static Git newBranch(Git git, String branchName) throws GitAPIException {
        return GitUtil.newBranch(git, branchName, null, null);
    }

    public static Git openOrClone(String workDir, String repo, String branch, String user, String pwd) throws GitAPIException {
        try {
            Git git = Git.open((File)new File(workDir));
            return git;
        }
        catch (IOException e) {
            UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(GitUtil.getUser(user), GitUtil.getPwd(pwd));
            File dir = new File(workDir);
            Git git = ((CloneCommand)Git.cloneRepository().setDirectory(dir).setCloneSubmodules(true).setURI(repo).setBranch(branch).setCredentialsProvider((CredentialsProvider)cp)).call();
            return git;
        }
    }

    public static PullResult pull(Git git, String user, String pwd) throws Exception {
        UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(GitUtil.getUser(user), GitUtil.getPwd(pwd));
        return ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)cp)).call();
    }

    public static Git openOrClone(String workDir, String repo, String branch) throws GitAPIException {
        return GitUtil.openOrClone(workDir, repo, branch, null, null);
    }

    public static String getUser(String user) {
        if (StringUtil.isNotNull((Object)user) && !"none".equals(user)) {
            return user;
        }
        return Conf.get((String)"common.others.git.username");
    }

    public static String getPwd(String pwd) {
        if (StringUtil.isNotNull((Object)pwd) && !"none".equals(pwd)) {
            return pwd;
        }
        return Conf.get((String)"common.others.git.password");
    }

    public static String getHostUrl(String repos) {
        if (StringUtils.isBlank((CharSequence)repos)) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(repos);
            return String.format("%s://%s:%d", url.getProtocol(), url.getHost(), url.getPort());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static Git merge(Git git, String branchSrc, String branchDst, boolean forceCreateDst) throws GitAPIException {
        List localBranchRefs = git.branchList().call();
        List remoteBranchRefs = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
        Ref srcLocalRef = GitUtil.getBranchRef(localBranchRefs, branchSrc);
        Ref srcRemoteRef = GitUtil.getBranchRef(remoteBranchRefs, branchSrc);
        if (null == srcLocalRef && null == srcRemoteRef) {
            return git;
        }
        if (null == srcLocalRef && null != srcRemoteRef) {
            git.branchCreate().setName(branchSrc).setStartPoint(srcRemoteRef.getName()).call();
        }
        Ref dstLocalRef = GitUtil.getBranchRef(localBranchRefs, branchDst);
        Ref dstRemoteRef = GitUtil.getBranchRef(remoteBranchRefs, branchDst);
        if (null == dstLocalRef && null == dstRemoteRef) {
            if (forceCreateDst) {
                git.branchCreate().setName(branchDst).setStartPoint(branchSrc).call();
            } else {
                throw new RuntimeException(String.format("branch[%s] is not exist", branchDst));
            }
        }
        if (null == dstLocalRef && null != dstRemoteRef) {
            git.branchCreate().setName(branchDst).setStartPoint(dstRemoteRef.getName()).call();
        }
        localBranchRefs = git.branchList().call();
        srcLocalRef = GitUtil.getBranchRef(localBranchRefs, branchSrc);
        git.checkout().setName(branchDst).call();
        MergeResult mergeResult = git.merge().include(srcLocalRef).call();
        GitUtil.checkMergeResult(mergeResult);
        return git;
    }

    public static Git merge4Master(Git git, String branch) throws GitAPIException {
        return GitUtil.merge(git, "master", branch, false);
    }

    public static Git push2Branch(Git git, String branch, String user, String pwd) throws GitAPIException {
        GitUtil.merge4Master(git, branch);
        ((PushCommand)git.push().add(branch).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(GitUtil.getUser(user), GitUtil.getPwd(pwd)))).call();
        return git;
    }

    public static Git add(Git git, String filePath) throws GitAPIException {
        git.add().setUpdate(false).addFilepattern(filePath).call();
        return git;
    }

    public static Git add(Git git) throws GitAPIException {
        return GitUtil.add(git, ".");
    }

    public static Git commit(Git git, String message) throws GitAPIException {
        GitUtil.add(git);
        git.commit().setMessage(message).call();
        return git;
    }

    public static Git commitNoAdd(Git git, String message) throws GitAPIException {
        git.commit().setMessage(message).call();
        return git;
    }

    public static Git push(Git git, String branch, String user, String pwd) throws GitAPIException {
        ((PushCommand)git.push().add(branch).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(GitUtil.getUser(user), GitUtil.getPwd(pwd)))).call();
        return git;
    }

    public static Git push2Branch(Git git, String branch) throws GitAPIException {
        return GitUtil.push2Branch(git, branch, null, null);
    }

    public static Git push2Master(Git git, String branch, String user, String pwd) throws GitAPIException {
        GitUtil.merge(git, branch, "master", true);
        ((PushCommand)git.push().add("master").setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(GitUtil.getUser(user), GitUtil.getPwd(pwd)))).call();
        return git;
    }

    public static Git push2Master(Git git, String branch) throws GitAPIException {
        return GitUtil.push2Master(git, branch, null, null);
    }

    private static void checkMergeResult(MergeResult mergeResult) {
        if (null == mergeResult) {
            throw new RuntimeException("merge result is empty");
        }
        if (!mergeResult.getMergeStatus().isSuccessful()) {
            if (null != mergeResult.getConflicts()) {
                throw new RuntimeException("files with any conflict: " + mergeResult.getConflicts().keySet().toString());
            }
            throw new RuntimeException(mergeResult.toString());
        }
    }

    private static Ref getBranchRef(List<Ref> branchRefs, String branchName) {
        for (Ref eachRef : branchRefs) {
            if (!eachRef.getName().equals("refs/heads/" + branchName) && !eachRef.getName().equals("refs/remotes/origin/" + branchName)) continue;
            return eachRef;
        }
        return null;
    }
}

