/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others.producer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerKafka
implements ObjectCreator<KafkaProducer<String, byte[]>> {
    private static final Logger log = LoggerFactory.getLogger(ProducerKafka.class);
    private Map<String, String> nameToType = new HashMap<String, String>();

    public ProducerKafka() {
        this.nameToType.put("retries", "integer");
        this.nameToType.put("max.block.ms", "long");
        this.nameToType.put("max.in.flight.requests.per.connection", "integer");
        this.nameToType.put("linger.ms", "integer");
        this.nameToType.put("batch.size", "integer");
        this.nameToType.put("buffer.memory", "integer");
        this.nameToType.put("max.request.size", "integer");
        this.nameToType.put("receive.buffer.bytes", "integer");
        this.nameToType.put("request.timeout.ms", "integer");
        this.nameToType.put("send.buffer.bytes", "integer");
        this.nameToType.put("connections.max.idle.ms", "integer");
    }

    public KafkaProducer<String, byte[]> createObject() {
        Map paramsMap = Conf.getPre((String)"common.others.kafka.");
        Properties prop = new Properties();
        for (String key : paramsMap.keySet()) {
            if (!StringUtil.isNotNull(paramsMap.get(key))) continue;
            String keytrue = key.replace("common.others.kafka.", "");
            if (this.nameToType.containsKey(keytrue)) {
                if ("integer".equals(this.nameToType.get(keytrue))) {
                    prop.put(keytrue, (Object)Integer.parseInt((String)paramsMap.get(key)));
                    continue;
                }
                if (!"long".equals(this.nameToType.get(keytrue))) continue;
                prop.put(keytrue, (Object)Long.parseLong(((String)paramsMap.get(key)).replace("l", "").replace("L", "")));
                continue;
            }
            prop.put(keytrue, paramsMap.get(key));
        }
        log.info("kafka\u53c2\u6570:");
        for (Object propele : prop.keySet()) {
            log.info("{}:{}", propele, prop.get(propele));
        }
        KafkaProducer producer = new KafkaProducer(prop);
        return producer;
    }
}

