/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others.docker;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import java.net.URI;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerUtilSpotify {
    private static final Logger log = LoggerFactory.getLogger(DockerUtilSpotify.class);
    private static DockerUtilSpotify inst = new DockerUtilSpotify();
    private final DockerClient docker;

    public DockerClient getDocker() {
        return this.docker;
    }

    private DockerUtilSpotify() {
        String url = Conf.get((String)"common.others.docker.url");
        int poosize = Integer.parseInt(Conf.get((String)"common.others.docker.poolSize"));
        this.docker = DefaultDockerClient.builder().uri(URI.create(url)).connectionPoolSize(poosize).build();
    }

    public static DockerUtilSpotify getInst() {
        return inst;
    }

    public Result startContainer(ContainerConfig config) {
        try {
            ContainerCreation container = this.docker.createContainer(config);
            this.docker.startContainer(container.id());
            return Result.getSuc((String)container.id());
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u5bb9\u5668\u5931\u8d25", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }

    public Result startContainer(String imageId, String ... params) {
        ContainerConfig config = ContainerConfig.builder().image(imageId).cmd(params).build();
        return this.startContainer(config);
    }

    public Result pushImage(String imageName) {
        try {
            this.docker.push(imageName);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5bb9\u5668\u51fa\u9519", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }
}

