/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others.constant;

import java.util.ArrayList;
import java.util.Map;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.others.JenkinsUtil;
import net.wicp.tams.common.others.constant.DeployTypeParam;

public enum DeployType implements IEnumCombobox
{
    jar("\u4e8c\u65b9\u5e93"),
    docker("\u53ea\u6253docker\u5e76\u63a8\u9001\u5230\u6ce8\u518c\u4e2d\u5fc3"),
    rc("\u53ea\u53d1rc"),
    svc("\u9700\u8981\u53d1\u5e03\u670d\u52a1");

    private final String desc;

    private DeployType(String desc) {
        this.desc = desc;
    }

    public static String getJenkinsScript(DeployType deployType, Map<DeployTypeParam, String> params) {
        ArrayList<String> stages = new ArrayList<String>();
        stages.add(JenkinsUtil.getScriptGit(params.get((Object)DeployTypeParam.repo), params.get((Object)DeployTypeParam.branch)));
        stages.add(JenkinsUtil.getScriptBuild(params.get((Object)DeployTypeParam.skipTest) == null ? null : Boolean.valueOf(Boolean.parseBoolean(params.get((Object)DeployTypeParam.skipTest)))));
        switch (deployType) {
            case jar: {
                stages.add(JenkinsUtil.getScriptDeploy());
                break;
            }
            case docker: {
                stages.add(JenkinsUtil.getScriptDockerBuild());
                stages.add(JenkinsUtil.getScriptDockerPush(params.get((Object)DeployTypeParam.catalog), params.get((Object)DeployTypeParam.tag)));
                break;
            }
            case rc: {
                stages.add(JenkinsUtil.getScriptDockerBuild());
                stages.add(JenkinsUtil.getScriptDockerPush(params.get((Object)DeployTypeParam.catalog), params.get((Object)DeployTypeParam.tag)));
                stages.add(JenkinsUtil.getScriptAddRc(params.get((Object)DeployTypeParam.msgid)));
                break;
            }
            case svc: {
                stages.add(JenkinsUtil.getScriptDockerBuild());
                stages.add(JenkinsUtil.getScriptDockerPush(params.get((Object)DeployTypeParam.catalog), params.get((Object)DeployTypeParam.tag)));
                stages.add(JenkinsUtil.getScriptAddRc(params.get((Object)DeployTypeParam.msgid)));
                stages.add(JenkinsUtil.getScriptAddSvc(params.get((Object)DeployTypeParam.msgid)));
                break;
            }
        }
        return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
    }

    public String getName() {
        return this.name();
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.desc;
    }

    public String getDesc_zh() {
        return this.desc;
    }
}

