/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.rds.model.v20140815.DescribeBinlogFilesRequest;
import com.aliyuncs.rds.model.v20140815.DescribeBinlogFilesResponse;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstanceHAConfigRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstanceHAConfigResponse;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesResponse;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.http.download.Download;
import net.wicp.tams.common.others.util.AcsClientCreator;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdsUtil {
    private static final Logger log = LoggerFactory.getLogger(RdsUtil.class);

    public static List<String> findDBInstanceIds() {
        DescribeDBInstancesRequest describe = new DescribeDBInstancesRequest();
        ObjectCreator creator = PerthreadManager.getInstance().createValue((Object)"aliyun-java-sdk-rds", (ObjectCreator)new AcsClientCreator());
        IAcsClient client = (IAcsClient)creator.createObject();
        try {
            DescribeDBInstancesResponse response = (DescribeDBInstancesResponse)client.getAcsResponse((AcsRequest)describe);
            List items = response.getItems();
            ArrayList<String> retlist = new ArrayList<String>();
            for (DescribeDBInstancesResponse.DBInstance dbInstance : items) {
                retlist.add(dbInstance.getDBInstanceId());
            }
            return retlist;
        }
        catch (Exception e) {
            log.error("\u521b\u5efaDBInstancesResponse\u65f6\u5931\u8d25", (Throwable)e);
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static List<DescribeDBInstanceHAConfigResponse.NodeInfo> findNodeInfos(String dbInstanceId) {
        DescribeDBInstanceHAConfigRequest request = new DescribeDBInstanceHAConfigRequest();
        request.setDBInstanceId(dbInstanceId);
        ObjectCreator creator = PerthreadManager.getInstance().createValue((Object)"aliyun-java-sdk-rds", (ObjectCreator)new AcsClientCreator());
        IAcsClient client = (IAcsClient)creator.createObject();
        try {
            DescribeDBInstanceHAConfigResponse response = (DescribeDBInstanceHAConfigResponse)client.getAcsResponse((AcsRequest)request);
            List items = response.getHostInstanceInfos();
            return items;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8282\u70b9\u5931\u8d25", (Throwable)e);
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static List<DescribeBinlogFilesResponse.BinLogFile> findBinLogFiles(String dbInstanceId, Date startTime, Date endTime) {
        Validate.notNull((Object)dbInstanceId, (String)"db\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)startTime, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DescribeBinlogFilesRequest request = new DescribeBinlogFilesRequest();
        request.setDBInstanceId(dbInstanceId);
        request.setStartTime(DateFormatCase.TZyyyyMMddHHmmss.getInstanc().format(startTime));
        request.setEndTime(DateFormatCase.TZyyyyMMddHHmmss.getInstanc().format(endTime));
        ObjectCreator creator = PerthreadManager.getInstance().createValue((Object)"aliyun-java-sdk-rds", (ObjectCreator)new AcsClientCreator());
        IAcsClient client = (IAcsClient)creator.createObject();
        try {
            DescribeBinlogFilesResponse resp = (DescribeBinlogFilesResponse)client.getAcsResponse((AcsRequest)request);
            List binlogs = resp.getItems();
            return binlogs;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42binlog\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static List<DescribeBinlogFilesResponse.BinLogFile> findBinLogFilesMax(String dbInstanceId, final String hostInstanceId, Date startTime, Date endTime) {
        List<DescribeBinlogFilesResponse.BinLogFile> retlist = RdsUtil.findBinLogFiles(dbInstanceId, startTime, endTime);
        CollectionUtils.filter(retlist, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                DescribeBinlogFilesResponse.BinLogFile temp = (DescribeBinlogFilesResponse.BinLogFile)object;
                return hostInstanceId.equals(temp.getHostInstanceID());
            }
        });
        return retlist;
    }

    public static String downloadBinLogFiles(DescribeBinlogFilesResponse.BinLogFile binLogFile, String dirPath) throws IOException {
        return RdsUtil.downloadBinLogFiles(binLogFile, new File(dirPath));
    }

    public static String downloadBinLogFiles(DescribeBinlogFilesResponse.BinLogFile binLogFile, File file) throws IOException {
        if (file == null) {
            return "";
        }
        if (!file.exists()) {
            file.mkdir();
        }
        Download download = new Download(binLogFile.getDownloadLink(), binLogFile.getFileSize().longValue(), file.getPath(), null);
        String retpath = download.download();
        return retpath;
    }
}

