package net.wicp.tams.common.others.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.others.JenkinsUtil;

public enum DeployType implements IEnumCombobox {
	jar("二方库"),

	docker("只打docker并推送到注册中心"),

	rc("只发rc"),

	svc("需要发布服务");

	private final String desc;

	private DeployType(String desc) {
		this.desc = desc;
	}

	/***
	 * common:repo/branch/skipTest
	 * 
	 * 得到script
	 * 
	 * @param deployType
	 * @param params
	 * @return
	 */
	public static String getJenkinsScript(DeployType deployType, Map<DeployTypeParam, String> params) {
		List<String> stages = new ArrayList<>();
		stages.add(JenkinsUtil.getScriptGit(params.get(DeployTypeParam.repo), params.get(DeployTypeParam.branch)));
		stages.add(JenkinsUtil.getScriptBuild(params.get(DeployTypeParam.skipTest) == null ? null
				: Boolean.parseBoolean(params.get(DeployTypeParam.skipTest))));
		switch (deployType) {
		case jar:
			stages.add(JenkinsUtil.getScriptDeploy());
			break;
		case docker:
			stages.add(JenkinsUtil.getScriptDockerBuild());
			stages.add(JenkinsUtil.getScriptDockerPush(params.get(DeployTypeParam.catalog),
					params.get(DeployTypeParam.tag)));
			break;
		case rc:
			stages.add(JenkinsUtil.getScriptDockerBuild());
			stages.add(JenkinsUtil.getScriptDockerPush(params.get(DeployTypeParam.catalog),
					params.get(DeployTypeParam.tag)));
			stages.add(JenkinsUtil.getScriptAddRc(params.get(DeployTypeParam.msgid)));
			break;
		case svc:
			stages.add(JenkinsUtil.getScriptDockerBuild());
			stages.add(JenkinsUtil.getScriptDockerPush(params.get(DeployTypeParam.catalog),
					params.get(DeployTypeParam.tag)));
			stages.add(JenkinsUtil.getScriptAddRc(params.get(DeployTypeParam.msgid)));
			stages.add(JenkinsUtil.getScriptAddSvc(params.get(DeployTypeParam.msgid)));
			break;
		default:
			break;
		}
		return JenkinsUtil.getTemp(stages.toArray(new String[stages.size()]));
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.desc;
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}
}
