/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.constant.DateFormatCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNUtil {
    private static final Logger log = LoggerFactory.getLogger(SVNUtil.class);
    private static volatile SVNUtil INSTANCE;
    private Map<String, SVNClientManager> managerMap = new HashMap<String, SVNClientManager>();
    private String[] ignorefiles = new String[]{".project", ".classpath"};
    private String[] ignoreDirs = new String[]{"target", ".settings", ".svn", "bin"};

    private SVNUtil() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        log.info("\u521b\u5efaSVNUtil\u5b9e\u4f8b\u6210\u529f");
    }

    public SVNClientManager authSvn(String svnRoot, String username, String password) {
        if (this.managerMap.get(svnRoot) != null) {
            return this.managerMap.get(svnRoot);
        }
        SVNRepository repository = null;
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnRoot));
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
            return null;
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (char[])password.toCharArray());
        repository.setAuthenticationManager(authManager);
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        SVNClientManager clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        this.managerMap.put(svnRoot, clientManager);
        return clientManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SVNUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SVNUtil> clazz = SVNUtil.class;
        synchronized (SVNUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SVNUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public SVNCommitInfo makeDirectory(SVNClientManager clientManager, SVNURL url, String commitMessage) {
        try {
            return clientManager.getCommitClient().doMkDir(new SVNURL[]{url}, commitMessage);
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
            return null;
        }
    }

    public SVNCommitInfo importDirectory(SVNClientManager clientManager, File localPath, SVNURL dstURL, String commitMessage, boolean isRecursive) {
        try {
            return clientManager.getCommitClient().doImport(localPath, dstURL, commitMessage, null, true, true, SVNDepth.fromRecurse((boolean)isRecursive));
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
            return null;
        }
    }

    public void addEntry(SVNClientManager clientManager, File wcPath) {
        try {
            clientManager.getWCClient().doAdd(new File[]{wcPath}, true, false, false, SVNDepth.INFINITY, false, false, true);
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
        }
    }

    public SVNStatus showStatus(SVNClientManager clientManager, File wcPath, boolean remote) {
        SVNStatus status = null;
        try {
            status = clientManager.getStatusClient().doStatus(wcPath, remote);
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
        }
        return status;
    }

    public Result commit(SVNClientManager clientManager, File wcPath, boolean keepLocks, String commitMessage) {
        try {
            this.checkVersiondDirectory(clientManager, wcPath);
            clientManager.getCommitClient().doCommit(new File[]{wcPath}, keepLocks, commitMessage, null, null, false, false, SVNDepth.INFINITY);
            return Result.getSuc();
        }
        catch (SVNException e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public long update(SVNClientManager clientManager, File wcPath, SVNRevision updateToRevision, SVNDepth depth) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doUpdate(wcPath, updateToRevision, depth, false, false);
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public long checkout(SVNClientManager clientManager, String svnPath, SVNRevision revision, File destPath, SVNDepth depth) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doCheckout(this.packUrl(svnPath), destPath, revision, revision, depth, false);
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Result overWrite(SVNClientManager clientManager, File workDir, String svnUrl) {
        String workDirPath = System.getProperty("user.home");
        File homeDir = new File(String.format("%s/%s/%s", workDirPath, "/.zhongan/", workDir.getName()));
        try {
            if (homeDir.exists()) {
                FileUtils.forceDelete((File)homeDir);
            }
            INSTANCE.checkout(clientManager, svnUrl, SVNRevision.HEAD, homeDir, SVNDepth.fromRecurse((boolean)true));
            FileUtils.copyDirectory((File)workDir, (File)homeDir, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !SVNUtil.this.isIgnorefiles(pathname);
                }
            });
        }
        catch (IOException e) {
            log.error("\u5408\u5e76\u4ee3\u7801\u9519\u8bef", (Throwable)e);
            return Result.getError((String)"\u5408\u5e76\u4ee3\u7801\u9519\u8bef");
        }
        Result retinfo = INSTANCE.commit(clientManager, homeDir, true, "\u5408\u5e76SVN\uff0c\u65f6\u95f4:" + DateFormatCase.yyyyMMddHHmmss.getInstanc().format(new Date()));
        return retinfo;
    }

    public Result merge(SVNClientManager clientManager, File workDir, String svnUrl, boolean commit) {
        String workDirPath = System.getProperty("user.home");
        File homeDir = new File(String.format("%s/%s/%s", workDirPath, "/.zhongan/", workDir.getName()));
        try {
            try {
                FileUtils.forceDelete((File)homeDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            INSTANCE.checkout(clientManager, svnUrl, SVNRevision.HEAD, homeDir, SVNDepth.fromRecurse((boolean)true));
            SVNDiffClient diff = clientManager.getDiffClient();
            diff.doMerge(homeDir, SVNRevision.HEAD, workDir, SVNRevision.HEAD, homeDir, SVNDepth.fromRecurse((boolean)true), false, false, false, false);
        }
        catch (Exception e) {
            log.error("\u5408\u5e76\u4ee3\u7801\u9519\u8bef", (Throwable)e);
            return Result.getError((String)"\u5408\u5e76\u4ee3\u7801\u9519\u8bef");
        }
        if (commit) {
            Result retinfo = INSTANCE.commit(clientManager, homeDir, true, "\u5408\u5e76SVN\uff0c\u65f6\u95f4:" + DateFormatCase.yyyyMMddHHmmss.getInstanc().format(new Date()));
            return retinfo.setRetObjs(new Object[]{homeDir});
        }
        return Result.getSuc().setRetObjs(new Object[]{homeDir});
    }

    public boolean isWorkingCopy(File path) {
        if (!path.exists()) {
            log.warn("'" + path + "' not exist!");
            return false;
        }
        try {
            if (null == SVNWCUtil.getWorkingCopyRoot((File)path, (boolean)false)) {
                return false;
            }
        }
        catch (SVNException e) {
            log.error(e.getErrorMessage().getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean isURLExist(SVNClientManager clientManager, String svnPath) {
        try {
            SVNRepository svnRepository = clientManager.createRepository(this.packUrl(svnPath), true);
            SVNNodeKind nodeKind = svnRepository.checkPath("", -1L);
            return nodeKind != SVNNodeKind.NONE;
        }
        catch (SVNException e) {
            e.printStackTrace();
            return false;
        }
    }

    private SVNURL packUrl(String svn) throws SVNException {
        return SVNURL.parseURIEncoded((String)svn);
    }

    public long doSwitch(SVNClientManager clientManager, File destPath, String svnUrlStr) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doSwitch(destPath, this.packUrl(svnUrlStr), SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.fromRecurse((boolean)false), false, false);
        }
        catch (SVNException e) {
            return -1L;
        }
    }

    public void checkVersiondDirectory(SVNClientManager clientManager, File wc) {
        if (!SVNWCUtil.isVersionedDirectory((File)wc) && !this.isIgnorefiles(wc)) {
            this.addEntry(clientManager, wc);
        }
        if (wc.isDirectory()) {
            for (File sub : wc.listFiles()) {
                if (sub.isDirectory() && sub.getName().equals(".svn")) continue;
                this.checkVersiondDirectory(clientManager, sub);
            }
        }
    }

    public boolean isIgnorefiles(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        boolean isIgnore = false;
        if (file.isDirectory()) {
            String filePath = file.getPath().replace("\\", "/");
            for (String dir : this.ignoreDirs) {
                if (!ArrayUtils.contains((Object[])filePath.split("/"), (Object)dir)) continue;
                isIgnore = true;
                break;
            }
        } else {
            isIgnore = ArrayUtils.contains((Object[])this.ignorefiles, (Object)file.getName());
        }
        return isIgnore;
    }
}

