/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.others;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import java.net.URI;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerUtil {
    private static final Logger log = LoggerFactory.getLogger(DockerUtil.class);
    private static DockerUtil inst = new DockerUtil();
    private final DockerClient docker;

    public DockerClient getDocker() {
        return this.docker;
    }

    private DockerUtil() {
        String url = String.format("http://%s:%s", Conf.get((String)"common.others.docker.ip"), Conf.get((String)"common.others.docker.port"));
        int poosize = Integer.parseInt(Conf.get((String)"common.others.docker.poolSize"));
        this.docker = DefaultDockerClient.builder().uri(URI.create(url)).connectionPoolSize(poosize).build();
    }

    public static DockerUtil getInst() {
        return inst;
    }

    public Result startContainer(ContainerConfig config) {
        try {
            ContainerCreation container = this.docker.createContainer(config);
            this.docker.startContainer(container.id());
            return Result.getSuc((String)container.id());
        }
        catch (Exception e) {
            log.error("\u542f\u52a8\u5bb9\u5668\u5931\u8d25", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }

    public Result startContainer(String imageId, String ... params) {
        ContainerConfig config = ContainerConfig.builder().image(imageId).cmd(params).build();
        return this.startContainer(config);
    }
}

