package net.wicp.tams.common.others.producer;

import org.apache.kafka.clients.producer.KafkaProducer;

import net.wicp.tams.commons.thread.threadlocal.ObjectCreator;
import net.wicp.tams.commons.thread.threadlocal.PerthreadManager;

public abstract class ProducerAssit {
	private static final String perVarKafka = "perVarKafka";

	/***
	 * 每个线程只会创建一个实例
	 * 
	 * @return
	 */
	public static KafkaProducer<String, byte[]> createPerThreadKafkaProducer() {
		ObjectCreator<KafkaProducer<String, byte[]>> creator = PerthreadManager.getInstance().createValue(perVarKafka,
				new ProducerKafka());
		return creator.createObject();
	}
}
