package net.wicp.tams.common.others;

import java.net.URI;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.Result;

@Slf4j
public class DockerUtil {
	private static DockerUtil inst = new DockerUtil();
	private final DockerClient docker;

	public DockerClient getDocker() {
		return docker;
	}

	private DockerUtil() {
		String url = String.format("http://%s:%s", Conf.get("common.others.docker.ip"),
				Conf.get("common.others.docker.port"));
		final int poosize = Integer.parseInt(Conf.get("common.others.docker.poolSize"));
		docker = DefaultDockerClient.builder().uri(URI.create(url)).connectionPoolSize(poosize).build();
	}

	public static DockerUtil getInst() {
		return DockerUtil.inst;
	}

	/***
	 * 启动容器
	 * 
	 * @param config
	 * @return
	 */
	public Result startContainer(ContainerConfig config) {
		try {
			ContainerCreation container = docker.createContainer(config);
			docker.startContainer(container.id());
			return Result.getSuc(container.id());
		} catch (Exception e) {
			log.error("启动容器失败", e);
			return Result.getError(e.getMessage());
		}
	}

	public Result startContainer(String imageId, String... params) {
		ContainerConfig config = ContainerConfig.builder().image(imageId).cmd(params).build();
		return startContainer(config);
	}

}
