/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.os.tools;

import org.apache.commons.lang3.Validate;

import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;

public abstract class DockerAssit {
	public static String version() {
		return "docker -v";
	}

	public static String checkDocker() {
		return "command -v docker|grep -w docker |wc -l";
	}
	
	public static String run(String image, String imageback, String[] commandParams) {
		Validate.notEmpty(image, "image不能为空");
		StringBuilder builder = new StringBuilder("docker run");
		String commandStr = CollectionUtil.arrayJoin(commandParams, " ");
		builder.append(" " + StringUtil.hasNull(commandStr));
		builder.append(" " + image + " ");
		builder.append(" " + StringUtil.hasNull(imageback));
		return builder.toString();
	}

	public static String run(String image, String... commandParams) {
		return run(image, null, commandParams);
	}

	public static String build(String tag, String group, String dockfile, String workpath) {
		Validate.notEmpty(tag, "tag不能为空");
		String tagTrue = StringUtil.isNull(group) ? tag : IOUtil.mergeFolderAndFilePath(group, tag);
		String dockfileTrue = StringUtil.isNull(dockfile) ? "Dockerfile" : dockfile;
		String workpathTrue = StringUtil.isNull(workpath) ? "." : workpath;
		return String.format("docker build -f %s  -t=\"%s\"  %s", dockfileTrue, tagTrue, workpathTrue);
	}

	public static String build(String tag, String dockfile) {
		return build(tag, null, dockfile, null);
	}
}
