/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.os.constant;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 是与否枚举
 * 
 * @author andy.zhou
 * 
 */
public enum DiskType implements IEnumCombobox {
	data("数据分区"),

	root("系统根", "-root"),

	swap("交换分区", "-swap");

	private final String desc;
	private final String difstr;

	private DiskType(String desc) {
		this(desc, null);
	}

	private DiskType(String desc, String difstr) {
		this.desc = desc;
		this.difstr = difstr;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static DiskType find(String path) {
		if (StringUtils.isEmpty(path)) {
			return null;
		}
		for (DiskType ele : DiskType.values()) {
			if (ele.difstr != null && path.endsWith(ele.difstr)) {
				return ele;
			}
		}
		return DiskType.data;
	}
}
