/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.os.constant;

import org.apache.commons.lang3.ArrayUtils;

import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;

/****
 * centos命令
 * 
 * @author 偏锋书生
 *
 *         2018年7月12日
 */
public enum CommandCentOs {
	// sudo_su("sudo su -", "切换到root用户"),//不起作用，会调用超时

	ls("ls -[CommandParam] %s", "ltr --time-style '+%%Y-%%m-%%d %%H:%%M:%%S'", "列出项", false), // grep ^d 显示目录 grep ^-
																								// 显示文件

	tar("tar -[CommandParam] %s", "xvf", "解压tar包", true), // 默认参数为解压tar包
	
	cat("cat %s","","查看文件"),

	free("free -[CommandParam]", "m", "查看内存使用情况"),
	
	mkdir("mkdir -[CommandParam] %s", "p", "创建目录"),
	
	fdisk("fdisk -[CommandParam]", "l", "查看磁盘"), //运维
	
	gpasswd("gpasswd  -[CommandParam] %s %s","a","增加用户到某个组",false),//gpasswd -a xplat docker ，docker加完用户重启下
	
	dockerps("docker ps -[CommandParam]","-no-trunc","查看docker的容器"), //得到docker的容器

	jps("jps -[CommandParam]", "lv", "查看java进程");// |grep imsc_to_zeus-consumer

	private final String desc;
	private final String command;
	private final String defaultCommandParam;
	private boolean needMultiConvOne = false;

	private CommandCentOs(String command, String defaultCommandParam, String desc) {
		this.command = command;
		this.defaultCommandParam = defaultCommandParam;
		this.desc = desc;
	}

	private CommandCentOs(String command, String defaultCommandParam, String desc, boolean needMultiConvOne) {
		this(command, defaultCommandParam, desc);
		this.needMultiConvOne = needMultiConvOne;
	}

	public String getDesc() {
		return desc;
	}

	public String getCommand(String commandParam, String[] grepStrs, Object... params) {
		String commonParams = StringUtil.isNull(commandParam) ? defaultCommandParam : commandParam;
		String retstr = this.command.replace("[CommandParam]", commonParams);
		if (ArrayUtils.isNotEmpty(grepStrs)) {
			for (String grepStr : grepStrs) {
				retstr += "|grep " + grepStr.replaceAll("grep", "").replaceAll("GREP", "");
			}
		}
		if (ArrayUtils.isEmpty(params)) {
			return retstr;
		} else {
			if (needMultiConvOne) {
				String arrayJoin = CollectionUtil.arrayJoin(params, " ");
				return String.format(retstr, arrayJoin);
			} else {
				return String.format(retstr, params);
			}
		}
	}

	public String getCommand(String... grepStrs) {
		return getCommand(null, grepStrs, new Object[0]);
	}

	public String getCommand(String grepStr, Object... params) {
		String[] grepStrParam = StringUtil.isNull(grepStr) ? new String[0] : new String[] { grepStr };
		return getCommand(null, grepStrParam, params);
	}

	public String getCommand(Object... params) {
		return getCommand(null, null, params);
	}

	public String getCommand() {
		return getCommand(new String[] {});
	}
}
