/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.pool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.beans.Host;
import net.wicp.tams.common.os.pool.SSHConnection;
import net.wicp.tams.common.os.pool.SSHFactoryByKey;
import net.wicp.tams.common.os.pool.SSHPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class SSHPoolByMap {
    private Map<Host, SSHPool> allPool = new HashMap<Host, SSHPool>();
    private final List<Host> hostList = new ArrayList<Host>();
    private final GenericObjectPoolConfig<SSHConnection> poolConfig;

    public SSHPoolByMap(List<Host> conf) {
        this(conf, (GenericObjectPoolConfig<SSHConnection>)new GenericObjectPoolConfig());
    }

    public SSHPoolByMap(List<Host> conf, GenericObjectPoolConfig<SSHConnection> poolConfig) {
        this.poolConfig = poolConfig;
        if (conf != null) {
            this.hostList.addAll(conf);
        }
    }

    public void addHost(Host key) {
        this.hostList.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SSHConnection borrowObject(Host key) throws Exception {
        if (this.allPool.containsKey(key)) return (SSHConnection)this.allPool.get(key).borrowObject();
        Class<SSHFactoryByKey> clazz = SSHFactoryByKey.class;
        synchronized (SSHFactoryByKey.class) {
            if (this.allPool.containsKey(key)) return (SSHConnection)this.allPool.get(key).borrowObject();
            int indexOf = this.hostList.indexOf(key);
            if (indexOf < 0) {
                indexOf = this.hostList.size();
                this.hostList.add(key);
            }
            Host host = this.hostList.get(indexOf);
            SSHPool fat = new SSHPool(host.getHostIp(), host.getPort(), StringUtil.hasNull((String[])new String[]{host.getUserName(), Conf.get((String)"common.os.ssh.username")}), StringUtil.hasNull((String[])new String[]{host.getPassword(), Conf.get((String)"common.os.ssh.pwd")}), this.poolConfig);
            this.allPool.put(host, fat);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (SSHConnection)this.allPool.get(key).borrowObject();
        }
    }

    public void returnObject(Host key, SSHConnection conn) throws Exception {
        if (this.allPool.get(key) != null) {
            this.allPool.get(key).returnObject(conn);
        }
    }
}

