/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.pool;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionMonitor;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.tools.PathEndFilter;
import net.wicp.tams.common.beans.MemoryInfo;
import net.wicp.tams.common.callback.ILineProcessor;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.SizeUnit;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.os.bean.DiskBean;
import net.wicp.tams.common.os.bean.DockContainer;
import net.wicp.tams.common.os.bean.FileBean;
import net.wicp.tams.common.os.constant.CommandCentOs;
import net.wicp.tams.common.os.constant.DiskType;
import net.wicp.tams.common.os.tools.DockerAssit;
import net.wicp.tams.common.thread.ThreadPool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHConnection {
    private static final Logger log = LoggerFactory.getLogger(SSHConnection.class);
    private final Connection conn;
    private boolean isClosed = false;

    public Connection getConn() {
        return this.conn;
    }

    public SSHConnection(Connection conn) {
        Validate.notNull((Object)conn, (String)"conn\u4e0d\u9700\u9700\u4f20null\u503c", (Object[])new Object[0]);
        Validate.isTrue((boolean)conn.isAuthenticationComplete(), (String)"SSH authentication failed", (Object[])new Object[0]);
        SSHConnectionMonitor connMonitor = new SSHConnectionMonitor();
        conn.addConnectionMonitor((ConnectionMonitor)connMonitor);
        this.conn = conn;
    }

    public Session openSession() throws ProjectException {
        Session openSession;
        try {
            openSession = this.conn.openSession();
        }
        catch (IOException e) {
            log.error("opensession error", (Throwable)e);
            throw new ProjectException((IExcept)ExceptAll.ssh_session_open, e.getMessage());
        }
        return openSession;
    }

    public SCPClient createSCPClient() throws ProjectException {
        try {
            SCPClient createSCPClient = this.conn.createSCPClient();
            return createSCPClient;
        }
        catch (IOException e) {
            log.error("opensession error", (Throwable)e);
            throw new ProjectException((IExcept)ExceptAll.ssh_client_create, e.getMessage());
        }
    }

    public void close() {
        this.isClosed = true;
        this.conn.close();
    }

    public boolean isConnClose() {
        return this.isClosed;
    }

    public Map<Integer, String> jps(String ... greps) {
        String cmdstr = CommandCentOs.jps.getCommand(greps);
        Result jpsResult = this.executeCommand(cmdstr);
        String[] jpsDetails = jpsResult.getMessage().split("\n");
        HashMap<Integer, String> retmap = new HashMap<Integer, String>();
        for (String jpsDetail : jpsDetails) {
            int firstblank = jpsDetail.indexOf(" ");
            retmap.put(new Integer(jpsDetail.substring(0, firstblank)), jpsDetail.substring(firstblank + 1));
        }
        return retmap;
    }

    public List<DockContainer> dockerps(String ... greps) {
        String cmdstr = CommandCentOs.dockerps.getCommand(greps);
        Result jpsResult = this.executeCommand(cmdstr);
        String[] psDetails = jpsResult.getMessage().split("\n");
        ArrayList<DockContainer> retlist = new ArrayList<DockContainer>();
        for (String psDetail : psDetails) {
            String[] psEleAry = psDetail.replaceAll("\\s{2,}", "|").split("\\|");
            if (psEleAry.length < 7) {
                log.error("\u4e0d\u89c4\u5219\u7684\u8fd4\u56de\uff1a{}", (Object)psDetail);
                continue;
            }
            DockContainer ele = new DockContainer();
            ele.setContainerId(psEleAry[0]);
            ele.setImage(psEleAry[1]);
            ele.setCommand(psEleAry[2]);
            ele.setCreated(psEleAry[3]);
            ele.setStatus(psEleAry[4]);
            ele.setPorts(psEleAry[5]);
            ele.setNames(psEleAry[6]);
            retlist.add(ele);
        }
        return retlist;
    }

    public List<DiskBean> fdisk() {
        String cmdstr = CommandCentOs.fdisk.getCommand();
        Result jpsResult = this.executeCommand(cmdstr);
        String[] psDetails = jpsResult.getMessage().split("\r\n");
        ArrayList<DiskBean> retlist = new ArrayList<DiskBean>();
        for (String ele : psDetails) {
            int firstindex = ele.indexOf("/dev/");
            if (firstindex <= 0) continue;
            String[] eleduans = ele.split(",");
            DiskBean addBean = new DiskBean();
            String[] temp = eleduans[0].split("\uff1a");
            addBean.setPath(temp[0].substring(firstindex));
            Pair convertUnit = SizeUnit.ConvertUnit((String)temp[1]);
            addBean.setCapacity((Double)convertUnit.getLeft());
            addBean.setSizeUnit((SizeUnit)convertUnit.getRight());
            retlist.add(addBean);
        }
        return retlist;
    }

    public List<DiskBean> fdiskData() {
        List<DiskBean> fdisk = this.fdisk();
        CollectionUtils.filter(fdisk, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                DiskBean temp = (DiskBean)object;
                return temp.getDiskType() == DiskType.data;
            }
        });
        return fdisk;
    }

    public Result kill(JvmStatus jvmStatus, int procId) {
        Result jpsResult = this.executeCommand(String.format("kill -%s %s", jvmStatus.getValue(), procId));
        return jpsResult;
    }

    public Result killDocker(String containerId) {
        Result jpsResult = this.executeCommand(String.format("docker kill %s", containerId));
        return jpsResult;
    }

    public MemoryInfo freeM() {
        String cmdstr = CommandCentOs.free.getCommand();
        Result jpsResult = this.executeCommand(cmdstr);
        String[] jpsDetails = jpsResult.getMessage().split("\n");
        MemoryInfo returnobj = new MemoryInfo();
        String[] mens = jpsDetails[1].replaceAll("\\s+", "|").replaceAll(",", "").replaceAll("\\[", "").replaceAll("\\]", "").replace("\r", "").split("\\|");
        returnobj.setTotalMemory(Integer.parseInt(mens[1]));
        returnobj.setUsedMemory(Integer.parseInt(mens[2]));
        returnobj.setFreeMemory(Integer.parseInt(mens[3]));
        returnobj.setSharedMemory(Integer.parseInt(mens[4]));
        returnobj.setBuffMemory(Integer.parseInt(mens[5]));
        returnobj.setAvailableMemory(Integer.parseInt(mens[6]));
        String[] swaps = jpsDetails[2].replaceAll("\\s+", "|").replaceAll(",", "").replaceAll("\\[", "").replaceAll("\\]", "").replace("\r", "").split("\\|");
        returnobj.setTotalSwap(Integer.parseInt(swaps[1]));
        returnobj.setUsedSwap(Integer.parseInt(swaps[2]));
        returnobj.setFreeSwap(Integer.parseInt(swaps[3]));
        return returnobj;
    }

    public boolean isSessionClose(Session session) {
        try {
            Object retobj = ReflectAssist.getPrivateField((Object)session, (String)"flag_closed");
            return (Boolean)retobj;
        }
        catch (Exception e) {
            log.error("get flag_closed error", (Throwable)e);
            return true;
        }
    }

    public Result executeCommand(String cmd) {
        return this.executeCommand(cmd, Conf.getInt((String)"common.os.ssh.cmd.timeout"));
    }

    public Result executeCommand(CommandCentOs cmd, String grepStr, Object ... params) {
        return this.executeCommand(cmd.getCommand(grepStr, params));
    }

    public Result tarX(String filePath, String toDirPath) {
        if (StringUtil.isNull((Object)toDirPath)) {
            int lastIndexOf = filePath.lastIndexOf("/");
            toDirPath = filePath.substring(0, lastIndexOf);
        }
        return this.executeCommand(CommandCentOs.tar, null, filePath, "-C", toDirPath);
    }

    public Result tarX(String filePath) {
        return this.tarX(filePath, null);
    }

    public Result addUser(String userName, String password) {
        String cmd = String.format("useradd -m -d /home/%s -s /bin/bash %s -p  $(perl -e 'print crypt($ARGV[0], \"password\")' %s)", userName, userName, password);
        Result executeCommand = this.executeCommand(cmd);
        if (!executeCommand.isSuc()) {
            return executeCommand;
        }
        String changeDate = "chage -M 9999 " + userName;
        Result changeResult = this.executeCommand(changeDate);
        return changeResult;
    }

    public YesOrNo checkDocker() {
        Result executeCommand = this.executeCommand(DockerAssit.checkDocker());
        if (!executeCommand.isSuc()) {
            return null;
        }
        if ("1".equals(executeCommand.getMessage())) {
            return YesOrNo.yes;
        }
        return YesOrNo.no;
    }

    public List<FileBean> llFile(String parentDir, YesOrNo isFile) {
        Result result = null;
        parentDir = StringUtil.hasNull((String[])new String[]{parentDir, ""});
        if (isFile == null) {
            result = this.executeCommand(CommandCentOs.ls, null, parentDir);
        } else {
            String grepstr = isFile == YesOrNo.yes ? "^-" : "^d";
            result = this.executeCommand(CommandCentOs.ls, grepstr, parentDir);
        }
        if (!result.isSuc()) {
            log.error("\u67e5\u8be2\u6587\u4ef6\u5217\u8868\u5931\u8d25", (Object)result.getMessage());
            return null;
        }
        ArrayList<FileBean> returnlist = new ArrayList<FileBean>();
        if (StringUtil.isNotNull((Object)result.getMessage())) {
            String[] listArry;
            for (String ele : listArry = result.getMessage().split("\n")) {
                String[] fileEleAry = ele.replaceAll("\\s+", "|").split("\\|");
                if (fileEleAry.length < 7) continue;
                FileBean tempobj = new FileBean();
                tempobj.setPermission(fileEleAry[0]);
                tempobj.setGroup(fileEleAry[2]);
                tempobj.setUser(fileEleAry[3]);
                tempobj.setSize(Long.parseLong(fileEleAry[4]));
                try {
                    String str = String.format("%s %s", fileEleAry[5], fileEleAry[6]);
                    tempobj.setLastUpdateTime(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().parse(str));
                }
                catch (Exception e) {
                    log.error("\u65f6\u95f4\u89e3\u6790\u51fa\u9519", (Throwable)e);
                }
                tempobj.setFileName(fileEleAry[fileEleAry.length - 1]);
                returnlist.add(tempobj);
            }
        }
        return returnlist;
    }

    public Result executeCommand(String cmd, int timoutMillis) {
        return this.executeCommand(cmd, null, timoutMillis, false);
    }

    public Result executeCommand(String cmd, ILineProcessor lineProcessor) {
        return this.executeCommand(cmd, lineProcessor, (int)Conf.getInt((String)"common.os.ssh.cmd.timeout"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result executeCommand(String cmd, ILineProcessor lineProcessor, int timoutMillis, boolean needroot) {
        Session session = null;
        try {
            session = this.conn.openSession();
            Result result = this.executeCommand(session, cmd, timoutMillis, lineProcessor);
            return result;
        }
        catch (Exception e) {
            String errmsg = "execute ip:" + this.conn.getHostname() + " cmd:" + cmd;
            log.error(errmsg, (Throwable)e);
            Result result = new Result((IExcept)ExceptAll.ssh_session_command);
            return result;
        }
        finally {
            SSHConnection.close(session);
        }
    }

    public Result executeCommand(final Session session, final String cmd, int timoutMillis, final ILineProcessor lineProcessor) throws ProjectException {
        Future<Result> future = ThreadPool.getDefaultPool().submit(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                session.execCommand(cmd);
                if (lineProcessor != null) {
                    SSHConnection.this.processStream(session.getStdout(), lineProcessor);
                } else {
                    String rst = SSHConnection.this.slurp(session.getStdout());
                    if (rst != null) {
                        return Result.getSuc((String)rst);
                    }
                    Result errResult = SSHConnection.this.tryLogError(session.getStderr(), cmd);
                    if (errResult != null) {
                        return errResult;
                    }
                }
                return Result.getSuc();
            }
        });
        Result rst = null;
        try {
            rst = future.get(timoutMillis, TimeUnit.MILLISECONDS);
            future.cancel(true);
        }
        catch (TimeoutException e) {
            log.error("exec ip:{} {} timeout:{}", new Object[]{this.conn.getHostname(), cmd, timoutMillis});
            rst = new Result((IExcept)ExceptAll.project_timeout);
        }
        catch (Exception e) {
            log.error("exec common error", (Throwable)e);
            throw new ProjectException((IExcept)ExceptAll.ssh_session_command, e.getMessage());
        }
        return rst;
    }

    private Result tryLogError(InputStream is, String cmd) {
        String errInfo = this.slurp(is);
        if (errInfo != null) {
            log.error("address " + this.conn.getHostname() + " execute cmd:({}), err:{}", (Object)cmd, (Object)errInfo);
            return Result.getError((String)errInfo);
        }
        return null;
    }

    public Result scpDir(String localDir, String remoteTargetDir, String mode, String[] includePaths, String ... excludePaths) {
        try {
            SCPClient client = this.conn.createSCPClient();
            this.scpDirDo(client, new File(localDir), remoteTargetDir, mode, includePaths, excludePaths);
            return Result.getSuc();
        }
        catch (IOException e) {
            String errmsg = "scp to " + remoteTargetDir + " localDir=" + localDir + " err";
            log.error(errmsg, (Throwable)e);
            return Result.getError((String)errmsg);
        }
    }

    private void scpDirDo(SCPClient client, File localDir, String remoteTargetDir, String mode, String[] includePaths, String[] excludePaths) throws IOException {
        PathEndFilter pathEndFilter = new PathEndFilter(localDir.getPath(), excludePaths, includePaths);
        Object[] listFiles = localDir.listFiles((FilenameFilter)pathEndFilter);
        if (ArrayUtils.isEmpty((Object[])listFiles)) {
            return;
        }
        ArrayList<Object> files = new ArrayList<Object>();
        ArrayList<Object> dirs = new ArrayList<Object>();
        for (Object object : listFiles) {
            if (((File)object).isDirectory()) {
                dirs.add(object);
                continue;
            }
            files.add(object);
        }
        String[] localFiles = new String[files.size()];
        int i = 0;
        for (File file : files) {
            localFiles[i++] = file.getPath();
        }
        if (localFiles.length > 0) {
            client.put(localFiles, remoteTargetDir, mode);
        }
        for (File file : dirs) {
            String targetDir = IOUtil.mergeFolderAndFilePath((String)remoteTargetDir, (String[])new String[]{file.getName()});
            Result creatDir = this.executeCommand(CommandCentOs.mkdir, null, targetDir);
            if (!creatDir.isSuc()) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25:" + creatDir.getMessage());
            }
            this.scpDirDo(client, file, targetDir, mode, null, null);
        }
    }

    public Result scp(String[] localFiles, String[] remoteFiles, String remoteTargetDirectory, String mode) {
        try {
            SCPClient client = this.conn.createSCPClient();
            client.put(localFiles, remoteFiles, remoteTargetDirectory, mode);
            return Result.getSuc();
        }
        catch (Exception e) {
            String msg = "scp local=" + Arrays.toString(localFiles) + " to " + remoteTargetDirectory + " remote=" + Arrays.toString(remoteFiles) + " err";
            log.error(msg, (Throwable)e);
            return Result.getError((String)msg);
        }
    }

    public Result scp(String localFile, String remoteFileName, String remoteTargetDirectory, String mode) {
        try {
            SCPClient client = this.conn.createSCPClient();
            client.put(localFile, remoteFileName, remoteTargetDirectory, mode);
            return Result.getSuc();
        }
        catch (Exception e) {
            String errmsg = "scp to " + remoteTargetDirectory + " localFile=" + localFile + " err";
            log.error(errmsg, (Throwable)e);
            return Result.getError((String)errmsg);
        }
    }

    public Result scp(byte[] data, String remoteFileName, String remoteTargetDirectory, String mode) {
        try {
            SCPClient client = this.conn.createSCPClient();
            client.put(data, remoteFileName, remoteTargetDirectory, mode);
            return Result.getSuc();
        }
        catch (Exception e) {
            String errmsg = "scp to " + remoteTargetDirectory + " err";
            log.error(errmsg, (Throwable)e);
            return Result.getError((String)errmsg);
        }
    }

    public Result scpToDir(String localFile, String remoteTargetDirectory) {
        return this.scpToDir(localFile, remoteTargetDirectory, "0744");
    }

    public Result scpToDir(String localFile, String remoteTargetDirectory, String mode) {
        return this.scp(new String[]{localFile}, null, remoteTargetDirectory, mode);
    }

    public Result scpToFile(String localFile, String remoteFile, String remoteTargetDirectory) {
        return this.scpToFile(localFile, remoteFile, remoteTargetDirectory, "0744");
    }

    public Result scpToFile(String localFile, String remoteFile, String remoteTargetDirectory, String mode) {
        return this.scp(new String[]{localFile}, new String[]{remoteFile}, remoteTargetDirectory, "0744");
    }

    private String slurp(InputStream is) {
        final StringBuilder buffer = new StringBuilder();
        ILineProcessor lp = new ILineProcessor(){

            public void process(String line, int lineNum) throws Exception {
                if (lineNum > 1) {
                    buffer.append(System.lineSeparator());
                }
                buffer.append(line);
            }

            public void finish() {
            }
        };
        this.processStream(is, lp);
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStream(InputStream is, ILineProcessor lineProcessor) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new StreamGobbler(is)));
            String line = null;
            int lineNum = 1;
            while ((line = reader.readLine()) != null) {
                try {
                    lineProcessor.process(line, lineNum);
                }
                catch (Exception e) {
                    log.error("err line:" + line, (Throwable)e);
                }
                ++lineNum;
            }
            lineProcessor.finish();
            this.close(reader);
        }
        catch (IOException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                this.close(reader);
            }
            catch (Throwable throwable) {
                this.close(reader);
                throw throwable;
            }
        }
    }

    private void close(BufferedReader read) {
        if (read != null) {
            try {
                read.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void close(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class SSHConnectionMonitor
    implements ConnectionMonitor {
        private SSHConnectionMonitor() {
        }

        public void connectionLost(Throwable reason) {
            SSHConnection.this.isClosed = true;
        }
    }
}

