package net.wicp.tams.common.os.bean;

import lombok.Data;
import net.wicp.tams.common.constant.dic.SizeUnit;
import net.wicp.tams.common.os.constant.DiskType;

/**
 * fdisk -l 得到磁盘
 * 
 * @author Andy
 *
 */
@Data
public class DiskBean {
	private String path;// 磁盘挂载路径
	private double capacity;// 容量
	private SizeUnit sizeUnit;// 单位

	// 磁盘类型
	public DiskType getDiskType() {
		return DiskType.find(this.path);
	}
}
