/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.tools;

import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.lang3.Validate;

public abstract class DockerAssit {
    public static String version() {
        return "docker -v";
    }

    public static String checkDocker() {
        return "command -v docker|grep -w docker |wc -l";
    }

    public static String run(String image, String imageback, String[] commandParams) {
        Validate.notEmpty((CharSequence)image, (String)"image\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder("docker run");
        String commandStr = CollectionUtil.arrayJoin((Object[])commandParams, (String)" ");
        builder.append(" " + StringUtil.hasNull((String[])new String[]{commandStr}));
        builder.append(" " + image + " ");
        builder.append(" " + StringUtil.hasNull((String[])new String[]{imageback}));
        return builder.toString();
    }

    public static String run(String image, String ... commandParams) {
        return DockerAssit.run(image, null, commandParams);
    }

    public static String build(String tag, String group, String dockfile, String workpath) {
        Validate.notEmpty((CharSequence)tag, (String)"tag\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tagTrue = StringUtil.isNull((Object)group) ? tag : IOUtil.mergeFolderAndFilePath((String)group, (String[])new String[]{tag});
        String dockfileTrue = StringUtil.isNull((Object)dockfile) ? "Dockerfile" : dockfile;
        String workpathTrue = StringUtil.isNull((Object)workpath) ? "." : workpath;
        return String.format("docker build -f %s  -t=\"%s\"  %s", dockfileTrue, tagTrue, workpathTrue);
    }

    public static String build(String tag, String dockfile) {
        return DockerAssit.build(tag, null, dockfile, null);
    }
}

