/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.pool;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.os.pool.SSHConnection;
import net.wicp.tams.common.os.pool.SSHFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class SSHPool
extends GenericObjectPool<SSHConnection> {
    public SSHPool(String hostname, int port, String username, String password, GenericObjectPoolConfig<SSHConnection> poolConfig) {
        super((PooledObjectFactory)new SSHFactory(hostname, port, username, password), poolConfig);
        if (Conf.getBoolean((String)"common.os.ssh.uncork.needcheck").booleanValue()) {
            AbandonedConfig abandonedConfig = new AbandonedConfig();
            abandonedConfig.setRemoveAbandonedOnMaintenance(true);
            abandonedConfig.setRemoveAbandonedOnBorrow(true);
            abandonedConfig.setRemoveAbandonedTimeout(Conf.getInt((String)"common.os.ssh.uncork.removeAbandonedTimeout").intValue());
            super.setAbandonedConfig(abandonedConfig);
            super.setTimeBetweenEvictionRunsMillis((long)Conf.getInt((String)"common.os.ssh.uncork.timeBetweenEvictionRunsMillis").intValue());
        }
    }

    public SSHPool(String hostname, int port, String username, String password) {
        this(hostname, port, username, password, (GenericObjectPoolConfig<SSHConnection>)new GenericObjectPoolConfig());
    }

    public SSHPool(String hostname) {
        this(hostname, (GenericObjectPoolConfig<SSHConnection>)new GenericObjectPoolConfig());
    }

    public SSHPool(String hostname, GenericObjectPoolConfig<SSHConnection> poolConfig) {
        this(hostname, Conf.getInt((String)"common.os.ssh.port"), Conf.get((String)"common.os.ssh.username"), Conf.get((String)"common.os.ssh.pwd"), poolConfig);
    }
}

