/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.pool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.beans.Host;
import net.wicp.tams.common.os.pool.SSHConnection;
import net.wicp.tams.common.os.pool.SSHFactory;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;

public class SSHFactoryByKey
implements KeyedPooledObjectFactory<Host, SSHConnection> {
    private Map<Host, SSHFactory> allFactory = new HashMap<Host, SSHFactory>();
    private final List<Host> hostList = new ArrayList<Host>();

    public SSHFactoryByKey(List<Host> conf) {
        if (conf != null) {
            this.hostList.addAll(conf);
        }
    }

    public void addHost(Host key) {
        this.hostList.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PooledObject<SSHConnection> makeObject(Host key) throws Exception {
        if (this.allFactory.containsKey(key)) return this.allFactory.get(key).makeObject();
        Class<SSHFactoryByKey> clazz = SSHFactoryByKey.class;
        synchronized (SSHFactoryByKey.class) {
            if (this.allFactory.containsKey(key)) return this.allFactory.get(key).makeObject();
            int indexOf = this.hostList.indexOf(key);
            if (indexOf < 0) {
                indexOf = this.hostList.size();
                this.hostList.add(key);
            }
            Host host = this.hostList.get(indexOf);
            SSHFactory fat = new SSHFactory(host.getHostIp(), host.getPort(), StringUtil.hasNull((String[])new String[]{host.getUserName(), Conf.get((String)"common.os.ssh.username")}), StringUtil.hasNull((String[])new String[]{host.getPassword(), Conf.get((String)"common.os.ssh.pwd")}));
            this.allFactory.put(host, fat);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.allFactory.get(key).makeObject();
        }
    }

    public void destroyObject(Host key, PooledObject<SSHConnection> p) throws Exception {
        this.allFactory.get(key).destroyObject(p);
    }

    public boolean validateObject(Host key, PooledObject<SSHConnection> p) {
        return this.allFactory.get(key).validateObject(p);
    }

    public void activateObject(Host key, PooledObject<SSHConnection> p) throws Exception {
        this.allFactory.get(key).activateObject(p);
    }

    public void passivateObject(Host key, PooledObject<SSHConnection> p) throws Exception {
        this.allFactory.get(key).passivateObject(p);
    }
}

