/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.pool;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.os.SSHAssit;
import net.wicp.tams.common.os.pool.SSHConnection;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class SSHFactory
implements PooledObjectFactory<SSHConnection> {
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;

    public SSHFactory(String hostname, int port, String username, String password) {
        this.hostname = hostname;
        this.username = username;
        this.password = password;
        this.port = port;
    }

    public SSHFactory(String hostname, String username, String password) {
        this(hostname, Conf.getInt((String)"common.os.ssh.port"), username, password);
    }

    public SSHFactory(String hostname, String password) {
        this(hostname, Conf.getInt((String)"common.os.ssh.port"), "root", password);
    }

    public PooledObject<SSHConnection> makeObject() throws Exception {
        SSHConnection conn = SSHAssit.getConn(this.hostname, this.port, this.username, this.password);
        return new DefaultPooledObject((Object)conn);
    }

    public void destroyObject(PooledObject<SSHConnection> p) throws Exception {
        SSHConnection conn = (SSHConnection)p.getObject();
        conn.close();
    }

    public boolean validateObject(PooledObject<SSHConnection> p) {
        SSHConnection conn = (SSHConnection)p.getObject();
        return !conn.isConnClose();
    }

    public void activateObject(PooledObject<SSHConnection> p) throws Exception {
    }

    public void passivateObject(PooledObject<SSHConnection> p) throws Exception {
    }
}

