/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os.constant;

import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.lang3.ArrayUtils;

public enum CommandCentOs {
    ls("ls -[CommandParam] %s", "ltr --time-style '+%%Y-%%m-%%d %%H:%%M:%%S'", "\u5217\u51fa\u9879", false),
    tar("tar -[CommandParam] %s", "xvf", "\u89e3\u538btar\u5305", true),
    free("free -[CommandParam]", "m", "\u67e5\u770b\u5185\u5b58\u4f7f\u7528\u60c5\u51b5"),
    gpasswd("gpasswd  -[CommandParam] %s %s", "a", "\u589e\u52a0\u7528\u6237\u5230\u67d0\u4e2a\u7ec4", false),
    dockerps("docker ps -[CommandParam]", "-no-trunc", "\u67e5\u770bdocker\u7684\u5bb9\u5668"),
    jps("jps -[CommandParam]", "lv", "\u67e5\u770bjava\u8fdb\u7a0b");

    private final String desc;
    private final String command;
    private final String defaultCommandParam;
    private boolean needMultiConvOne = false;

    private CommandCentOs(String command, String defaultCommandParam, String desc) {
        this.command = command;
        this.defaultCommandParam = defaultCommandParam;
        this.desc = desc;
    }

    private CommandCentOs(String command, String defaultCommandParam, String desc, boolean needMultiConvOne) {
        this(command, defaultCommandParam, desc);
        this.needMultiConvOne = needMultiConvOne;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getCommand(String commandParam, String[] grepStrs, Object ... params) {
        String commonParams = StringUtil.isNull((Object)commandParam) ? this.defaultCommandParam : commandParam;
        String retstr = this.command.replace("[CommandParam]", commonParams);
        if (ArrayUtils.isNotEmpty((Object[])grepStrs)) {
            for (String grepStr : grepStrs) {
                retstr = retstr + "|grep " + grepStr.replaceAll("grep", "").replaceAll("GREP", "");
            }
        }
        if (ArrayUtils.isEmpty((Object[])params)) {
            return retstr;
        }
        if (this.needMultiConvOne) {
            String arrayJoin = CollectionUtil.arrayJoin((Object[])params, (String)" ");
            return String.format(retstr, arrayJoin);
        }
        return String.format(retstr, params);
    }

    public String getCommand(String ... grepStrs) {
        return this.getCommand((String)null, grepStrs, new Object[0]);
    }

    public String getCommand(String grepStr, Object ... params) {
        String[] stringArray;
        if (StringUtil.isNull((Object)grepStr)) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = grepStr;
        }
        String[] grepStrParam = stringArray;
        return this.getCommand((String)null, grepStrParam, params);
    }

    public String getCommand(Object ... params) {
        return this.getCommand((String)null, (String[])null, params);
    }

    public String getCommand() {
        return this.getCommand(new String[0]);
    }
}

