/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.os;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.os.constant.CommandCentOs;
import net.wicp.tams.common.os.pool.SSHConnection;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSHAssit {
    private static final Logger log = LoggerFactory.getLogger(SSHAssit.class);

    public static SSHConnection getConn(String ip, int port, String username, String password) throws ProjectException {
        Validate.notNull((Object)ip, (String)"SSH connection ip not null", (Object[])new Object[0]);
        Validate.notNull((Object)port, (String)"SSH connection port not null", (Object[])new Object[0]);
        Validate.notNull((Object)username, (String)"SSH connection username not null", (Object[])new Object[0]);
        Validate.notNull((Object)password, (String)"SSH connection password not null", (Object[])new Object[0]);
        Connection conn = new Connection(ip, port);
        try {
            conn.connect(null, Conf.getInt((String)"common.os.ssh.timeout").intValue(), Conf.getInt((String)"common.os.ssh.timeout").intValue());
        }
        catch (IOException e) {
            String errmsg = "SSH connection timeout with [ ip: " + ip + ", port: " + port + "]";
            log.error(errmsg, (Throwable)e);
            throw new ProjectException((IExcept)ExceptAll.project_timeout, errmsg);
        }
        try {
            boolean isAuthenticated = conn.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new ProjectException((IExcept)ExceptAll.ssh_auth_fail, "SSH authentication failed with [ userName: " + username + ", password: " + password + "]");
            }
        }
        catch (IOException e) {
            throw new ProjectException((IExcept)ExceptAll.ssh_auth_fail, "SSH authentication failed with [ userName: " + username + ", password: " + password + "]");
        }
        return new SSHConnection(conn);
    }

    public static Result callCommand(SSHConnection conn, CommandCentOs command, String grep, Object ... params) throws Exception {
        Session openSession = conn.getConn().openSession();
        String cmd = command.getCommand(grep, params);
        openSession.execCommand(cmd);
        String slurp = IOUtil.slurp((InputStream)openSession.getStdout());
        if (slurp != null) {
            Result suc = Result.getSuc();
            suc.setMessage(slurp);
            return suc;
        }
        Result errResult = SSHAssit.tryLogError(openSession.getStderr(), conn.getConn().getHostname(), cmd);
        return errResult;
    }

    private static Result tryLogError(InputStream is, String address, String cmd) throws IOException {
        String errInfo = IOUtil.slurp((InputStream)is);
        if (errInfo != null) {
            log.error("address " + address + " execute cmd:({}), err:{}", (Object)cmd, (Object)errInfo);
            return Result.getError((String)errInfo);
        }
        return Result.getError((String)"unknow");
    }
}

